/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe.mqtt3;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeView;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscriptionView;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscriptionViewBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscribeBuilder;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscription;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class Mqtt3SubscribeViewBuilder<B extends Mqtt3SubscribeViewBuilder<B>> {
    private final @NotNull ImmutableList.Builder<MqttSubscription> subscriptionsBuilder;
    private @Nullable Mqtt3SubscriptionViewBuilder.Default firstSubscriptionBuilder;

    protected Mqtt3SubscribeViewBuilder() {
        this.subscriptionsBuilder = ImmutableList.builder();
    }

    Mqtt3SubscribeViewBuilder(@NotNull Mqtt3SubscribeView subscribe) {
        List subscriptions = subscribe.getDelegate().getSubscriptions();
        this.subscriptionsBuilder = ImmutableList.builder(subscriptions.size() + 1);
        this.subscriptionsBuilder.addAll(subscriptions);
    }

    @NotNull
    protected abstract B self();

    @NotNull
    public B addSubscription(@Nullable Mqtt3Subscription subscription) {
        this.buildFirstSubscription();
        this.subscriptionsBuilder.add(Checks.notImplemented(subscription, Mqtt3SubscriptionView.class, "Subscription").getDelegate());
        return this.self();
    }

    public @NotNull Mqtt3SubscriptionViewBuilder.Nested<B> addSubscription() {
        return new Mqtt3SubscriptionViewBuilder.Nested<Mqtt3SubscribeViewBuilder>(this::addSubscription);
    }

    @NotNull
    public B addSubscriptions(Mqtt3Subscription ... subscriptions) {
        Checks.notNull(subscriptions, "Subscriptions");
        this.buildFirstSubscription();
        this.subscriptionsBuilder.ensureFree(subscriptions.length);
        for (Mqtt3Subscription subscription : subscriptions) {
            this.addSubscription(subscription);
        }
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addSubscriptions(@Nullable @Nullable Collection<@Nullable ? extends Mqtt3Subscription> subscriptions) {
        Checks.notNull(subscriptions, "Subscriptions");
        this.buildFirstSubscription();
        this.subscriptionsBuilder.ensureFree(subscriptions.size());
        subscriptions.forEach(this::addSubscription);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addSubscriptions(@Nullable @Nullable Stream<@Nullable ? extends Mqtt3Subscription> subscriptions) {
        Checks.notNull(subscriptions, "Subscriptions");
        this.buildFirstSubscription();
        subscriptions.forEach(this::addSubscription);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    private @NotNull Mqtt3SubscriptionViewBuilder.Default getFirstSubscriptionBuilder() {
        if (this.firstSubscriptionBuilder == null) {
            this.firstSubscriptionBuilder = new Mqtt3SubscriptionViewBuilder.Default();
        }
        return this.firstSubscriptionBuilder;
    }

    private void buildFirstSubscription() {
        if (this.firstSubscriptionBuilder != null) {
            this.subscriptionsBuilder.add(((Mqtt3SubscriptionView)this.firstSubscriptionBuilder.build()).getDelegate());
            this.firstSubscriptionBuilder = null;
        }
    }

    @NotNull
    public B topicFilter(@Nullable String topicFilter) {
        this.getFirstSubscriptionBuilder().topicFilter(topicFilter);
        return this.self();
    }

    @NotNull
    public B topicFilter(@Nullable MqttTopicFilter topicFilter) {
        this.getFirstSubscriptionBuilder().topicFilter(topicFilter);
        return this.self();
    }

    public  @NotNull MqttTopicFilterImplBuilder.Nested<B> topicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<Mqtt3SubscribeViewBuilder>(this::topicFilter);
    }

    @NotNull
    public B qos(@Nullable MqttQos qos) {
        this.getFirstSubscriptionBuilder().qos(qos);
        return this.self();
    }

    private void ensureAtLeastOneSubscription() {
        Checks.state(this.subscriptionsBuilder.getSize() > 0, "At least one subscription must be added.");
    }

    @NotNull
    public Mqtt3SubscribeView build() {
        this.buildFirstSubscription();
        this.ensureAtLeastOneSubscription();
        return Mqtt3SubscribeView.of(this.subscriptionsBuilder.build());
    }

    public static abstract class Publishes<P>
    extends Mqtt3SubscribeViewBuilder<Publishes<P>>
    implements Mqtt3SubscribeBuilder.Publishes.Start.Complete<P>,
    Mqtt3SubscribeBuilder.Publishes.Args<P> {
        protected boolean manualAcknowledgement;

        @Override
        @NotNull
        protected Publishes<P> self() {
            return this;
        }

        @Override
        @NotNull
        public Publishes<P> manualAcknowledgement(boolean manualAcknowledgement) {
            this.manualAcknowledgement = manualAcknowledgement;
            return this;
        }
    }

    public static class Send<P>
    extends Mqtt3SubscribeViewBuilder<Send<P>>
    implements Mqtt3SubscribeBuilder.Send.Start.Complete<P> {
        @NotNull
        private final Function<? super Mqtt3SubscribeView, P> parentConsumer;

        public Send(@NotNull Function<? super Mqtt3SubscribeView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends Mqtt3SubscribeViewBuilder<Nested<P>>
    implements Mqtt3SubscribeBuilder.Nested.Start.Complete<P> {
        @NotNull
        private final Function<? super Mqtt3SubscribeView, P> parentConsumer;

        public Nested(@NotNull Function<? super Mqtt3SubscribeView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applySubscribe() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Mqtt3SubscribeViewBuilder<Default>
    implements Mqtt3SubscribeBuilder.Start.Complete {
        public Default() {
        }

        Default(@NotNull Mqtt3SubscribeView subscribe) {
            super(subscribe);
        }

        @Override
        @NotNull
        protected Default self() {
            return this;
        }
    }
}

