/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.unsubscribe;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5UnsubscribeBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class MqttUnsubscribeBuilder<B extends MqttUnsubscribeBuilder<B>> {
    private final @NotNull ImmutableList.Builder<MqttTopicFilterImpl> topicFiltersBuilder;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    MqttUnsubscribeBuilder() {
        this.topicFiltersBuilder = ImmutableList.builder();
    }

    MqttUnsubscribeBuilder(@NotNull MqttUnsubscribe unsubscribe) {
        List topicFilters = unsubscribe.getTopicFilters();
        this.topicFiltersBuilder = ImmutableList.builder(topicFilters.size() + 1);
        this.topicFiltersBuilder.addAll(topicFilters);
    }

    @NotNull
    abstract B self();

    @NotNull
    public B addTopicFilter(@Nullable String topicFilter) {
        this.topicFiltersBuilder.add(MqttTopicFilterImpl.of(topicFilter));
        return this.self();
    }

    @NotNull
    public B addTopicFilter(@Nullable MqttTopicFilter topicFilter) {
        this.topicFiltersBuilder.add(MqttChecks.topicFilter(topicFilter));
        return this.self();
    }

    public  @NotNull MqttTopicFilterImplBuilder.Nested<B> addTopicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<MqttUnsubscribeBuilder>(this::addTopicFilter);
    }

    @NotNull
    public B addTopicFilters(MqttTopicFilter ... topicFilters) {
        Checks.notNull(topicFilters, "Topic Filters");
        this.topicFiltersBuilder.ensureFree(topicFilters.length);
        for (MqttTopicFilter topicFilter : topicFilters) {
            this.addTopicFilter(topicFilter);
        }
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addTopicFilters(@Nullable @Nullable Collection<@Nullable ? extends MqttTopicFilter> topicFilters) {
        Checks.notNull(topicFilters, "Topic Filters");
        this.topicFiltersBuilder.ensureFree(topicFilters.size());
        topicFilters.forEach(this::addTopicFilter);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B addTopicFilters(@Nullable @Nullable Stream<@Nullable ? extends MqttTopicFilter> topicFilters) {
        Checks.notNull(topicFilters, "Topic Filters");
        topicFilters.forEach(this::addTopicFilter);
        this.ensureAtLeastOneSubscription();
        return this.self();
    }

    @NotNull
    public B reverse(@Nullable Mqtt5Subscribe subscribe) {
        List subscriptions = MqttChecks.subscribe(subscribe).getSubscriptions();
        for (MqttSubscription subscription : subscriptions) {
            this.topicFiltersBuilder.add(subscription.getTopicFilter());
        }
        return this.self();
    }

    @NotNull
    public B userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this.self();
    }

    public  @NotNull MqttUserPropertiesImplBuilder.Nested<B> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttUnsubscribeBuilder>(this.userProperties, this::userProperties);
    }

    @NotNull
    public B topicFilter(@Nullable String topicFilter) {
        return this.addTopicFilter(topicFilter);
    }

    @NotNull
    public B topicFilter(@Nullable MqttTopicFilter topicFilter) {
        return this.addTopicFilter(topicFilter);
    }

    public  @NotNull MqttTopicFilterImplBuilder.Nested<B> topicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<MqttUnsubscribeBuilder>(this::topicFilter);
    }

    private void ensureAtLeastOneSubscription() {
        Checks.state(this.topicFiltersBuilder.getSize() > 0, "At least one topic filter must be added.");
    }

    @NotNull
    public MqttUnsubscribe build() {
        this.ensureAtLeastOneSubscription();
        return new MqttUnsubscribe(this.topicFiltersBuilder.build(), this.userProperties);
    }

    public static class Send<P>
    extends MqttUnsubscribeBuilder<Send<P>>
    implements Mqtt5UnsubscribeBuilder.Send.Complete<P>,
    Mqtt5UnsubscribeBuilder.Send.Start<P> {
        @NotNull
        private final Function<? super MqttUnsubscribe, P> parentConsumer;

        public Send(@NotNull Function<? super MqttUnsubscribe, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends MqttUnsubscribeBuilder<Nested<P>>
    implements Mqtt5UnsubscribeBuilder.Nested.Complete<P>,
    Mqtt5UnsubscribeBuilder.Nested.Start<P> {
        @NotNull
        private final Function<? super MqttUnsubscribe, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttUnsubscribe, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyUnsubscribe() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttUnsubscribeBuilder<Default>
    implements Mqtt5UnsubscribeBuilder.Complete,
    Mqtt5UnsubscribeBuilder.Start {
        public Default() {
        }

        Default(@NotNull MqttUnsubscribe unsubscribe) {
            super(unsubscribe);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

