/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx;

import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public final class RxFutureConverter {
    private static final int INITIAL = 0;
    private static final int SUBSCRIBED_OR_COMPLETE = 1;
    private static final int SUBSCRIBED_AND_COMPLETE_OR_CANCELLED = 2;

    @NotNull
    public static CompletableFuture<Void> toFuture(@NotNull Completable completable) {
        return new RxCompletableFuture(completable);
    }

    @NotNull
    public static <T> @NotNull CompletableFuture<@NotNull Optional<T>> toFuture(@NotNull Maybe<T> maybe) {
        return new RxMaybeFuture<T>(maybe);
    }

    @NotNull
    public static <T> @NotNull CompletableFuture<@NotNull T> toFuture(@NotNull Single<T> single) {
        return new RxSingleFuture<T>(single);
    }

    @NotNull
    public static Completable toCompletable(@NotNull CompletableFuture<?> future) {
        return new FutureCompletable(future);
    }

    @NotNull
    public static <T> Maybe<T> toMaybe(@NotNull @NotNull CompletableFuture<@NotNull Optional<T>> future) {
        return new FutureMaybe<T>(future);
    }

    @NotNull
    public static <T> Single<T> toSingle(@NotNull @NotNull CompletableFuture<@NotNull T> future) {
        return new FutureSingle<T>(future);
    }

    private static boolean checkComplete(@NotNull AtomicInteger done) {
        return !done.compareAndSet(0, 1) && done.compareAndSet(1, 2);
    }

    private static void dispose(@NotNull AtomicInteger done, @NotNull CompletableFuture<?> future) {
        done.set(2);
        future.cancel(false);
    }

    private static boolean isDisposed(@NotNull AtomicInteger done) {
        return done.get() == 2;
    }

    private RxFutureConverter() {
    }

    private static class FutureSingle<T>
    extends Single<T>
    implements Disposable,
    BiConsumer<T, Throwable> {
        @NotNull
        private final CompletableFuture<T> future;
        @Nullable
        private volatile SingleObserver<? super T> observer;
        @Nullable
        private volatile T t;
        @Nullable
        private volatile Throwable throwable;
        @NotNull
        private final AtomicInteger done = new AtomicInteger(0);

        FutureSingle(@NotNull CompletableFuture<T> future) {
            this.future = future;
            future.whenComplete((BiConsumer)this);
        }

        protected void subscribeActual(@NotNull SingleObserver<? super T> observer) {
            this.observer = observer;
            observer.onSubscribe((Disposable)this);
            if (RxFutureConverter.checkComplete(this.done)) {
                FutureSingle.complete(observer, this.t, this.throwable);
            }
        }

        public void dispose() {
            RxFutureConverter.dispose(this.done, this.future);
        }

        public boolean isDisposed() {
            return RxFutureConverter.isDisposed(this.done);
        }

        @Override
        public void accept(@Nullable T t, @Nullable Throwable throwable) {
            this.t = t;
            this.throwable = throwable;
            if (RxFutureConverter.checkComplete(this.done)) {
                SingleObserver<? super T> observer = this.observer;
                assert (observer != null);
                FutureSingle.complete(observer, t, throwable);
            }
        }

        private static <T> void complete(@NotNull SingleObserver<? super T> observer, @Nullable T t, @Nullable Throwable throwable) {
            if (t != null) {
                observer.onSuccess(t);
            } else {
                observer.onError(throwable != null ? throwable : new NullPointerException());
            }
        }
    }

    private static class FutureMaybe<T>
    extends Maybe<T>
    implements Disposable,
    BiConsumer<Optional<T>, Throwable> {
        @NotNull
        private final CompletableFuture<Optional<T>> future;
        @Nullable
        private volatile MaybeObserver<? super T> observer;
        @Nullable
        private volatile T t;
        @Nullable
        private volatile Throwable throwable;
        @NotNull
        private final AtomicInteger done = new AtomicInteger(0);

        FutureMaybe(@NotNull CompletableFuture<Optional<T>> future) {
            this.future = future;
            future.whenComplete((BiConsumer)this);
        }

        protected void subscribeActual(@NotNull MaybeObserver<? super T> observer) {
            this.observer = observer;
            observer.onSubscribe((Disposable)this);
            if (RxFutureConverter.checkComplete(this.done)) {
                FutureMaybe.complete(observer, this.t, this.throwable);
            }
        }

        public void dispose() {
            RxFutureConverter.dispose(this.done, this.future);
        }

        public boolean isDisposed() {
            return RxFutureConverter.isDisposed(this.done);
        }

        @Override
        public void accept(@Nullable Optional<T> t, @Nullable Throwable throwable) {
            Throwable throwable1;
            T t1;
            if (throwable == null) {
                if (t == null) {
                    t1 = null;
                    throwable1 = new NullPointerException();
                } else {
                    t1 = t.orElse(null);
                    throwable1 = null;
                }
            } else {
                t1 = null;
                throwable1 = throwable;
            }
            this.t = t1;
            this.throwable = throwable1;
            if (RxFutureConverter.checkComplete(this.done)) {
                MaybeObserver<? super T> observer = this.observer;
                assert (observer != null);
                FutureMaybe.complete(observer, t1, throwable1);
            }
        }

        private static <T> void complete(@NotNull MaybeObserver<? super T> observer, @Nullable T t, @Nullable Throwable throwable) {
            if (throwable != null) {
                observer.onError(throwable);
            } else if (t != null) {
                observer.onSuccess(t);
            } else {
                observer.onComplete();
            }
        }
    }

    private static class FutureCompletable
    extends Completable
    implements Disposable,
    BiConsumer<Object, Throwable> {
        @NotNull
        private final CompletableFuture<?> future;
        @Nullable
        private volatile CompletableObserver observer;
        @Nullable
        private volatile Throwable throwable;
        @NotNull
        private final AtomicInteger done = new AtomicInteger(0);

        FutureCompletable(@NotNull CompletableFuture<?> future) {
            this.future = future;
            future.whenComplete((BiConsumer)this);
        }

        protected void subscribeActual(@NotNull CompletableObserver observer) {
            this.observer = observer;
            observer.onSubscribe((Disposable)this);
            if (RxFutureConverter.checkComplete(this.done)) {
                FutureCompletable.complete(observer, this.throwable);
            }
        }

        public void dispose() {
            RxFutureConverter.dispose(this.done, this.future);
        }

        public boolean isDisposed() {
            return RxFutureConverter.isDisposed(this.done);
        }

        @Override
        public void accept(@Nullable Object o, @Nullable Throwable throwable) {
            this.throwable = throwable;
            if (RxFutureConverter.checkComplete(this.done)) {
                CompletableObserver observer = this.observer;
                assert (observer != null);
                FutureCompletable.complete(observer, throwable);
            }
        }

        private static void complete(@NotNull CompletableObserver observer, @Nullable Throwable throwable) {
            if (throwable == null) {
                observer.onComplete();
            } else {
                observer.onError(throwable);
            }
        }
    }

    private static class RxSingleFuture<T>
    extends RxFuture<T>
    implements SingleObserver<T> {
        RxSingleFuture(@NotNull Single<T> single) {
            single.subscribe((SingleObserver)this);
        }

        public void onSuccess(@NotNull T t) {
            if (!this.cancelled) {
                this.complete(t);
            }
        }
    }

    private static class RxMaybeFuture<T>
    extends RxFuture<Optional<T>>
    implements MaybeObserver<T> {
        RxMaybeFuture(@NotNull Maybe<T> maybe) {
            maybe.subscribe((MaybeObserver)this);
        }

        public void onSuccess(@NotNull T t) {
            if (!this.cancelled) {
                this.complete(Optional.of(t));
            }
        }

        public void onComplete() {
            if (!this.cancelled) {
                this.complete(Optional.empty());
            }
        }
    }

    private static class RxCompletableFuture
    extends RxFuture<Void>
    implements CompletableObserver {
        RxCompletableFuture(@NotNull Completable completable) {
            completable.subscribe((CompletableObserver)this);
        }

        public void onComplete() {
            if (!this.cancelled) {
                this.complete(null);
            }
        }
    }

    private static abstract class RxFuture<T>
    extends CompletableFuture<T> {
        @Nullable
        volatile Disposable disposable;
        volatile boolean cancelled;

        private RxFuture() {
        }

        public void onSubscribe(@NotNull Disposable d) {
            this.disposable = d;
            if (this.cancelled) {
                d.dispose();
            }
        }

        public void onError(@NotNull Throwable e) {
            if (!this.cancelled) {
                this.completeExceptionally(e);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            Disposable disposable = this.disposable;
            if (disposable != null) {
                disposable.dispose();
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

