/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.shaded.org.jctools.queues;

import com.hivemq.client.internal.shaded.org.jctools.queues.BaseSpscLinkedArrayQueue;
import com.hivemq.client.internal.shaded.org.jctools.queues.CircularArrayOffsetCalculator;
import com.hivemq.client.internal.shaded.org.jctools.queues.MessagePassingQueue;
import com.hivemq.client.internal.shaded.org.jctools.util.Pow2;
import com.hivemq.client.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class SpscUnboundedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    public SpscUnboundedArrayQueue(int chunkSize) {
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = chunkCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(chunkCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
    }

    @Override
    final boolean offerColdPath(E[] buffer, long mask, long pIndex, long offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            E[] newBuffer = CircularArrayOffsetCalculator.allocate((int)(mask + 2L));
            this.producerBuffer = newBuffer;
            this.producerBufferLimit = pIndex + mask - 1L;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int capacity() {
        return -1;
    }
}

