/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.mqtt.mqtt5.auth;

import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientConfig;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5Auth;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5EnhancedAuthBuilder;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import java.util.concurrent.CompletableFuture;

public interface Mqtt5EnhancedAuthMechanism {
    @NotNull
    public MqttUtf8String getMethod();

    public int getTimeout();

    @NotNull
    public CompletableFuture<Void> onAuth(@NotNull Mqtt5ClientConfig var1, @NotNull Mqtt5Connect var2, @NotNull Mqtt5EnhancedAuthBuilder var3);

    @NotNull
    public CompletableFuture<Void> onReAuth(@NotNull Mqtt5ClientConfig var1, @NotNull Mqtt5AuthBuilder var2);

    @NotNull
    default public CompletableFuture<Boolean> onServerReAuth(@NotNull Mqtt5ClientConfig clientConfig, @NotNull Mqtt5Auth auth, @NotNull Mqtt5AuthBuilder authBuilder) {
        return this.onReAuth(clientConfig, authBuilder).thenApply(aVoid -> true);
    }

    @NotNull
    public CompletableFuture<Boolean> onContinue(@NotNull Mqtt5ClientConfig var1, @NotNull Mqtt5Auth var2, @NotNull Mqtt5AuthBuilder var3);

    @NotNull
    public CompletableFuture<Boolean> onAuthSuccess(@NotNull Mqtt5ClientConfig var1, @NotNull Mqtt5ConnAck var2);

    @NotNull
    public CompletableFuture<Boolean> onReAuthSuccess(@NotNull Mqtt5ClientConfig var1, @NotNull Mqtt5Auth var2);

    public void onAuthRejected(@NotNull Mqtt5ClientConfig var1, @NotNull Mqtt5ConnAck var2);

    public void onReAuthRejected(@NotNull Mqtt5ClientConfig var1, @NotNull Mqtt5Disconnect var2);

    public void onAuthError(@NotNull Mqtt5ClientConfig var1, @NotNull Throwable var2);

    public void onReAuthError(@NotNull Mqtt5ClientConfig var1, @NotNull Throwable var2);
}

