/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.logging;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalNoopLogger;
import com.hivemq.client.internal.logging.InternalSlf4jLogger;
import org.jetbrains.annotations.NotNull;

public final class InternalLoggerFactory {
    private static final boolean SLF4J_AVAILABLE = InternalLoggerFactory.isAvailable("org.slf4j.Logger");

    private static boolean isAvailable(@NotNull String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @NotNull
    public static InternalLogger getLogger(@NotNull Class<?> clazz) {
        if (SLF4J_AVAILABLE) {
            return new InternalSlf4jLogger(clazz);
        }
        return new InternalNoopLogger(clazz);
    }

    private InternalLoggerFactory() {
    }
}

