/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientExecutorConfigImpl;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttClientExecutorConfigBuilder;
import io.reactivex.Scheduler;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttClientExecutorConfigImplBuilder<B extends MqttClientExecutorConfigImplBuilder<B>> {
    @Nullable
    private Executor nettyExecutor;
    private int nettyThreads = 0;
    @NotNull
    private Scheduler applicationScheduler = MqttClientExecutorConfigImpl.DEFAULT_APPLICATION_SCHEDULER;

    MqttClientExecutorConfigImplBuilder() {
    }

    MqttClientExecutorConfigImplBuilder(@NotNull MqttClientExecutorConfigImpl executorConfig) {
        this.nettyExecutor = executorConfig.getRawNettyExecutor();
        this.nettyThreads = executorConfig.getRawNettyThreads();
        this.applicationScheduler = executorConfig.getApplicationScheduler();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B nettyExecutor(@Nullable Executor nettyExecutor) {
        this.nettyExecutor = nettyExecutor;
        return this.self();
    }

    @NotNull
    public B nettyThreads(int nettyThreads) {
        if (nettyThreads <= 0) {
            throw new IllegalArgumentException("Number of Netty threads must be greater than 0. Found: " + nettyThreads);
        }
        this.nettyThreads = nettyThreads;
        return this.self();
    }

    @NotNull
    public B applicationScheduler(@Nullable Scheduler applicationScheduler) {
        this.applicationScheduler = Checks.notNull(applicationScheduler, "Application scheduler");
        return this.self();
    }

    @NotNull
    public MqttClientExecutorConfigImpl build() {
        return new MqttClientExecutorConfigImpl(this.nettyExecutor, this.nettyThreads, this.applicationScheduler);
    }

    public static class Nested<P>
    extends MqttClientExecutorConfigImplBuilder<Nested<P>>
    implements MqttClientExecutorConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttClientExecutorConfigImpl, P> parentConsumer;

        public Nested(@NotNull MqttClientExecutorConfigImpl executorConfig, @NotNull Function<? super MqttClientExecutorConfigImpl, P> parentConsumer) {
            super(executorConfig);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyExecutorConfig() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttClientExecutorConfigImplBuilder<Default>
    implements MqttClientExecutorConfigBuilder {
        public Default() {
        }

        Default(@NotNull MqttClientExecutorConfigImpl executorConfig) {
            super(executorConfig);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

