/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.connect;

import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5ConnAckException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
@Singleton
public class MqttDisconnectOnConnAckHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    public static final String NAME = "disconnect.on.connack";

    @Inject
    MqttDisconnectOnConnAckHandler() {
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttConnAck) {
            this.readConnAck(ctx, (MqttConnAck)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readConnAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttConnAck connAck) {
        MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Must not receive second CONNACK."));
    }

    public boolean isSharable() {
        return true;
    }
}

