/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttGlobalIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscriptionFlows;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttStatefulSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.MqttSubAck;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttStatefulUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.unsuback.MqttUnsubAck;
import com.hivemq.client.internal.mqtt.message.unsubscribe.unsuback.mqtt3.Mqtt3UnsubAckView;
import com.hivemq.client.internal.util.collections.HandleList;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAckReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAckReasonCode;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ClientScope
@NotThreadSafe
public class MqttIncomingPublishFlows {
    @NotNull
    private final MqttSubscriptionFlows subscriptionFlows;
    private final @Nullable HandleList<MqttGlobalIncomingPublishFlow> @NotNull [] globalFlows;

    @Inject
    MqttIncomingPublishFlows(@NotNull MqttSubscriptionFlows subscriptionFlows) {
        this.subscriptionFlows = subscriptionFlows;
        this.globalFlows = new HandleList[MqttGlobalPublishFilter.values().length];
    }

    public void subscribe(@NotNull MqttStatefulSubscribe subscribe, @Nullable MqttSubscribedPublishFlow flow) {
        List subscriptions = ((MqttSubscribe)subscribe.stateless()).getSubscriptions();
        for (int i = 0; i < subscriptions.size(); ++i) {
            this.subscribe(((MqttSubscription)subscriptions.get(i)).getTopicFilter(), flow);
        }
    }

    void subscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        this.subscriptionFlows.subscribe(topicFilter, flow);
    }

    public void subAck(@NotNull MqttStatefulSubscribe subscribe, @NotNull MqttSubAck subAck, @Nullable MqttSubscribedPublishFlow flow) {
        List subscriptions = ((MqttSubscribe)subscribe.stateless()).getSubscriptions();
        List reasonCodes = subAck.getReasonCodes();
        for (int i = 0; i < subscriptions.size(); ++i) {
            if (!((Mqtt5SubAckReasonCode)reasonCodes.get(i)).isError()) continue;
            this.remove(((MqttSubscription)subscriptions.get(i)).getTopicFilter(), flow);
        }
    }

    void remove(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        this.subscriptionFlows.remove(topicFilter, flow);
    }

    public void unsubscribe(@NotNull MqttStatefulUnsubscribe unsubscribe, @NotNull MqttUnsubAck unsubAck) {
        List topicFilters = ((MqttUnsubscribe)unsubscribe.stateless()).getTopicFilters();
        List reasonCodes = unsubAck.getReasonCodes();
        boolean areAllSuccess = reasonCodes == Mqtt3UnsubAckView.REASON_CODES_ALL_SUCCESS;
        for (int i = 0; i < topicFilters.size(); ++i) {
            if (!areAllSuccess && ((Mqtt5UnsubAckReasonCode)reasonCodes.get(i)).isError()) continue;
            this.unsubscribe((MqttTopicFilterImpl)topicFilters.get(i));
        }
    }

    void unsubscribe(@NotNull MqttTopicFilterImpl topicFilter) {
        this.subscriptionFlows.unsubscribe(topicFilter, null);
    }

    void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        this.subscriptionFlows.cancel(flow);
    }

    @NotNull
    HandleList<MqttIncomingPublishFlow> findMatching(@NotNull MqttStatefulPublish publish) {
        HandleList<MqttIncomingPublishFlow> matchingFlows = new HandleList<MqttIncomingPublishFlow>();
        this.findMatching(publish, matchingFlows);
        return matchingFlows;
    }

    void findMatching(@NotNull MqttStatefulPublish publish, @NotNull HandleList<MqttIncomingPublishFlow> matchingFlows) {
        MqttTopicImpl topic = ((MqttPublish)publish.stateless()).getTopic();
        if (this.subscriptionFlows.findMatching(topic, matchingFlows) || !matchingFlows.isEmpty()) {
            MqttIncomingPublishFlows.add(matchingFlows, this.globalFlows[MqttGlobalPublishFilter.SUBSCRIBED.ordinal()]);
        } else {
            MqttIncomingPublishFlows.add(matchingFlows, this.globalFlows[MqttGlobalPublishFilter.UNSOLICITED.ordinal()]);
        }
        MqttIncomingPublishFlows.add(matchingFlows, this.globalFlows[MqttGlobalPublishFilter.ALL.ordinal()]);
        if (matchingFlows.isEmpty()) {
            MqttIncomingPublishFlows.add(matchingFlows, this.globalFlows[MqttGlobalPublishFilter.REMAINING.ordinal()]);
        }
    }

    void subscribeGlobal(@NotNull MqttGlobalIncomingPublishFlow flow) {
        int filter = flow.getFilter().ordinal();
        HandleList<MqttGlobalIncomingPublishFlow> globalFlow = this.globalFlows[filter];
        if (globalFlow == null) {
            this.globalFlows[filter] = globalFlow = new HandleList();
        }
        flow.setHandle(globalFlow.add(flow));
    }

    void cancelGlobal(@NotNull MqttGlobalIncomingPublishFlow flow) {
        HandleList.Handle<MqttGlobalIncomingPublishFlow> handle = flow.getHandle();
        assert (handle != null);
        handle.remove();
        int filter = flow.getFilter().ordinal();
        HandleList<MqttGlobalIncomingPublishFlow> globalFlow = this.globalFlows[filter];
        assert (globalFlow != null);
        if (globalFlow.isEmpty()) {
            this.globalFlows[filter] = null;
        }
    }

    void clear(@NotNull Throwable cause) {
        this.subscriptionFlows.clear(cause);
        for (int i = 0; i < this.globalFlows.length; ++i) {
            HandleList<MqttGlobalIncomingPublishFlow> globalFlow = this.globalFlows[i];
            if (globalFlow != null) {
                for (MqttGlobalIncomingPublishFlow flow : globalFlow) {
                    flow.onError(cause);
                }
            }
            this.globalFlows[i] = null;
        }
    }

    private static void add(@NotNull HandleList<MqttIncomingPublishFlow> target, @Nullable HandleList<? extends MqttIncomingPublishFlow> source) {
        if (source != null) {
            for (MqttIncomingPublishFlow mqttIncomingPublishFlow : source) {
                target.add(mqttIncomingPublishFlow);
            }
        }
    }
}

