/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.util.StringUtil;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5ReasonCode;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttMessageWithUserProperties
implements MqttMessage.WithUserProperties {
    @NotNull
    private final MqttUserPropertiesImpl userProperties;

    protected MqttMessageWithUserProperties(@NotNull MqttUserPropertiesImpl userProperties) {
        this.userProperties = userProperties;
    }

    @Override
    @NotNull
    public MqttUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    @NotNull
    protected String toAttributeString() {
        return this.userProperties.asList().isEmpty() ? "" : "userProperties=" + this.userProperties;
    }

    protected boolean partialEquals(@NotNull MqttMessageWithUserProperties that) {
        return this.userProperties.equals(that.userProperties);
    }

    protected int partialHashCode() {
        return this.userProperties.hashCode();
    }

    public static abstract class WithReason
    extends MqttMessageWithUserProperties {
        @Nullable
        private final MqttUtf8StringImpl reasonString;

        WithReason(@Nullable MqttUtf8StringImpl reasonString, @NotNull MqttUserPropertiesImpl userProperties) {
            super(userProperties);
            this.reasonString = reasonString;
        }

        @NotNull
        public Optional<MqttUtf8String> getReasonString() {
            return Optional.ofNullable(this.reasonString);
        }

        @Nullable
        public MqttUtf8StringImpl getRawReasonString() {
            return this.reasonString;
        }

        @Override
        @NotNull
        protected String toAttributeString() {
            return this.reasonString == null ? super.toAttributeString() : "reasonString=" + this.reasonString + StringUtil.prepend(", ", super.toAttributeString());
        }

        protected boolean partialEquals(@NotNull WithReason that) {
            return super.partialEquals(that) && Objects.equals(this.reasonString, that.reasonString);
        }

        @Override
        protected int partialHashCode() {
            return 31 * super.partialHashCode() + Objects.hashCode(this.reasonString);
        }

        public static abstract class WithCodesAndId<R extends Mqtt5ReasonCode>
        extends WithReason
        implements MqttMessage.WithId {
            private final int packetIdentifier;
            @NotNull
            private final @NotNull ImmutableList<@NotNull R> reasonCodes;

            protected WithCodesAndId(int packetIdentifier, @NotNull @NotNull ImmutableList<@NotNull R> reasonCodes, @Nullable MqttUtf8StringImpl reasonString, @NotNull MqttUserPropertiesImpl userProperties) {
                super(reasonString, userProperties);
                this.packetIdentifier = packetIdentifier;
                this.reasonCodes = reasonCodes;
            }

            @Override
            public int getPacketIdentifier() {
                return this.packetIdentifier;
            }

            @NotNull
            public @NotNull ImmutableList<@NotNull R> getReasonCodes() {
                return this.reasonCodes;
            }

            @Override
            @NotNull
            protected String toAttributeString() {
                return "packetIdentifier=" + this.packetIdentifier + StringUtil.prepend(", ", super.toAttributeString());
            }

            protected boolean partialEquals(@NotNull WithCodesAndId<R> that) {
                return super.partialEquals(that) && this.reasonCodes.equals(that.reasonCodes);
            }

            @Override
            protected int partialHashCode() {
                return 31 * super.partialHashCode() + this.reasonCodes.hashCode();
            }
        }

        public static abstract class WithCode<R extends Mqtt5ReasonCode>
        extends WithReason {
            @NotNull
            private final R reasonCode;

            protected WithCode(@NotNull R reasonCode, @Nullable MqttUtf8StringImpl reasonString, @NotNull MqttUserPropertiesImpl userProperties) {
                super(reasonString, userProperties);
                this.reasonCode = reasonCode;
            }

            @NotNull
            public R getReasonCode() {
                return this.reasonCode;
            }

            protected boolean partialEquals(@NotNull WithCode that) {
                return super.partialEquals(that) && this.reasonCode.equals(that.reasonCode);
            }

            @Override
            protected int partialHashCode() {
                return 31 * super.partialHashCode() + this.reasonCode.hashCode();
            }

            public static abstract class WithId<R extends Mqtt5ReasonCode>
            extends WithCode<R>
            implements MqttMessage.WithId {
                private final int packetIdentifier;

                protected WithId(int packetIdentifier, @NotNull R reasonCode, @Nullable MqttUtf8StringImpl reasonString, @NotNull MqttUserPropertiesImpl userProperties) {
                    super(reasonCode, reasonString, userProperties);
                    this.packetIdentifier = packetIdentifier;
                }

                @Override
                public int getPacketIdentifier() {
                    return this.packetIdentifier;
                }

                @Override
                @NotNull
                protected String toAttributeString() {
                    return "packetIdentifier=" + this.packetIdentifier + StringUtil.prepend(", ", super.toAttributeString());
                }
            }
        }
    }
}

