/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish.mqtt3;

import com.hivemq.client.internal.mqtt.message.publish.MqttPublishResult;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.mqtt3.exceptions.Mqtt3ExceptionFactory;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import io.reactivex.functions.Function;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mqtt3PublishResultView
implements Mqtt3PublishResult {
    @NotNull
    public static final Function<Mqtt5PublishResult, Mqtt3PublishResult> MAPPER = Mqtt3PublishResultView::of;
    @NotNull
    private final MqttPublishResult delegate;

    @NotNull
    public static Mqtt3PublishResultView of(@NotNull Mqtt5PublishResult publishResult) {
        return new Mqtt3PublishResultView((MqttPublishResult)publishResult);
    }

    private Mqtt3PublishResultView(@NotNull MqttPublishResult delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Mqtt3Publish getPublish() {
        return Mqtt3PublishView.of(this.delegate.getPublish());
    }

    @Override
    @NotNull
    public Optional<Throwable> getError() {
        return this.delegate.getError().map(Mqtt3ExceptionFactory.MAPPER_JAVA);
    }

    @NotNull
    private String toAttributeString() {
        return "publish=" + this.getPublish() + (!this.getError().isPresent() ? "" : ", error=" + this.getError().get());
    }

    @NotNull
    public String toString() {
        return "MqttPublishResult{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3PublishResultView)) {
            return false;
        }
        Mqtt3PublishResultView that = (Mqtt3PublishResultView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

