/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.netty;

import com.hivemq.client.internal.annotations.ThreadSafe;
import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.MultithreadEventLoopGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class NettyEventLoopProvider {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(NettyEventLoopProvider.class);
    @NotNull
    private final @NotNull Map<@Nullable Executor, @NotNull Entry> entries = new HashMap<Executor, Entry>();
    @NotNull
    private final BiFunction<Integer, Executor, MultithreadEventLoopGroup> eventLoopGroupFactory;
    @NotNull
    private final ChannelFactory<?> channelFactory;

    NettyEventLoopProvider(@NotNull BiFunction<Integer, Executor, MultithreadEventLoopGroup> eventLoopGroupFactory, @NotNull ChannelFactory<?> channelFactory) {
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.channelFactory = channelFactory;
    }

    @NotNull
    public synchronized EventLoop acquireEventLoop(@Nullable Executor executor, int threadCount) {
        Entry entry = this.entries.get(executor);
        if (entry == null) {
            entry = new Entry(this.eventLoopGroupFactory.apply(threadCount, executor));
            this.entries.put(executor, entry);
        } else {
            int previousThreadCount = entry.eventLoopGroup.executorCount();
            if (threadCount != 0 && previousThreadCount != threadCount) {
                LOGGER.warn("Tried to use a different amount of Netty threads for the same executor. Using {} threads instead of {}", previousThreadCount, threadCount);
            }
            ++entry.referenceCount;
        }
        return entry.eventLoopGroup.next();
    }

    public synchronized void releaseEventLoop(@Nullable Executor executor) {
        Entry entry = this.entries.get(executor);
        if (--entry.referenceCount == 0) {
            entry.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            this.entries.remove(executor);
        }
    }

    @NotNull
    public ChannelFactory<?> getChannelFactory() {
        return this.channelFactory;
    }

    private static class Entry {
        @NotNull
        final MultithreadEventLoopGroup eventLoopGroup;
        int referenceCount = 1;

        private Entry(@NotNull MultithreadEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
        }
    }
}

