/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import com.hivemq.client.internal.util.ByteArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteArray {
    @NotNull
    protected final byte[] array;

    public ByteArray(@NotNull byte[] array) {
        this.array = array;
    }

    public int length() {
        return this.getEnd() - this.getStart();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteArray)) {
            return false;
        }
        ByteArray that = (ByteArray)o;
        return ByteArrayUtil.equals(this.array, this.getStart(), this.getEnd(), that.array, that.getStart(), that.getEnd());
    }

    public int hashCode() {
        return ByteArrayUtil.hashCode(this.array, this.getStart(), this.getEnd());
    }

    protected int getStart() {
        return 0;
    }

    protected int getEnd() {
        return this.array.length;
    }

    public static class Range
    extends ByteArray {
        protected int start;
        protected int end;

        public Range(@NotNull byte[] array, int start, int end) {
            super(array);
            this.start = start;
            this.end = end;
        }

        @Override
        protected int getStart() {
            return this.start;
        }

        @Override
        protected int getEnd() {
            return this.end;
        }
    }
}

