/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class ChunkedArrayQueue<E>
implements Iterable<E> {
    private final int chunkSize;
    @Nullable
    private E single;
    @Nullable
    private Chunk<E> producerChunk;
    @Nullable
    private Chunk<E> consumerChunk;
    private int producerIndex;
    private int consumerIndex;
    private int size;
    @NotNull
    private final ChunkedArrayQueueIterator iterator = new ChunkedArrayQueueIterator();

    public ChunkedArrayQueue(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void offer(@NotNull E e) {
        if (this.size == 0) {
            this.size = 1;
            this.single = e;
            return;
        }
        if (this.size == 1) {
            E single;
            if (this.producerChunk == null) {
                this.consumerChunk = new Chunk(this.chunkSize);
                this.producerChunk = this.consumerChunk;
            }
            if ((single = this.single) != null) {
                this.size = 0;
                this.single = null;
                this.offerQueue(single);
            }
        }
        this.offerQueue(e);
    }

    private void offerQueue(@NotNull E e) {
        Chunk<E> producerChunk = this.producerChunk;
        assert (producerChunk != null);
        int producerIndex = this.producerIndex;
        if (producerIndex == this.chunkSize || producerChunk == this.consumerChunk && producerChunk.values[producerIndex] != null) {
            if (this.size >= this.chunkSize) {
                Chunk chunk = new Chunk(this.chunkSize);
                producerChunk.jumpIndex = producerIndex - 1;
                producerChunk.next = chunk;
                producerChunk = chunk;
                this.producerChunk = chunk;
            }
            producerIndex = 0;
        }
        producerChunk.values[producerIndex] = e;
        this.producerIndex = producerIndex + 1;
        ++this.size;
    }

    @Nullable
    public E poll() {
        E single = this.single;
        if (single != null) {
            this.size = 0;
            this.single = null;
            return single;
        }
        if (this.consumerChunk == null) {
            return null;
        }
        Chunk<E> consumerChunk = this.consumerChunk;
        int consumerIndex = this.consumerIndex;
        Object e = consumerChunk.values[consumerIndex];
        if (e == null) {
            return null;
        }
        consumerChunk.values[consumerIndex] = null;
        --this.size;
        if (consumerIndex == consumerChunk.jumpIndex) {
            assert (consumerChunk.next != null);
            consumerIndex = 0;
            this.consumerChunk = consumerChunk.next;
        } else if (++consumerIndex == this.chunkSize) {
            consumerIndex = 0;
        }
        this.consumerIndex = consumerIndex;
        return e;
    }

    @Nullable
    public E peek() {
        if (this.single != null) {
            return this.single;
        }
        if (this.consumerChunk == null) {
            return null;
        }
        return this.consumerChunk.values[this.consumerIndex];
    }

    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        this.iterator.clear();
        return this.iterator;
    }

    private class ChunkedArrayQueueIterator
    implements Iterator<E> {
        @Nullable
        private E iteratorSingle;
        @Nullable
        private Chunk<E> iteratorChunk;
        private int iteratorIndex;
        private int iterated;

        private ChunkedArrayQueueIterator() {
        }

        void clear() {
            this.iteratorSingle = ChunkedArrayQueue.this.single;
            this.iteratorChunk = ChunkedArrayQueue.this.consumerChunk;
            this.iteratorIndex = ChunkedArrayQueue.this.consumerIndex;
            this.iterated = 0;
        }

        @Override
        public boolean hasNext() {
            return this.iterated < ChunkedArrayQueue.this.size;
        }

        @Override
        @NotNull
        public E next() {
            Object iteratorSingle = this.iteratorSingle;
            if (iteratorSingle != null) {
                this.iterated = 1;
                this.iteratorSingle = null;
                return iteratorSingle;
            }
            if (this.iteratorChunk == null) {
                throw new NoSuchElementException();
            }
            Object e = this.iteratorChunk.values[this.iteratorIndex];
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (this.iteratorIndex == this.iteratorChunk.jumpIndex) {
                this.iteratorIndex = 0;
                this.iteratorChunk = this.iteratorChunk.next;
            } else {
                ++this.iteratorIndex;
                if (this.iteratorIndex == ChunkedArrayQueue.this.chunkSize) {
                    this.iteratorIndex = 0;
                }
            }
            ++this.iterated;
            return e;
        }

        @Override
        public void remove() {
            if (this.iterated != 1) {
                throw new IllegalStateException();
            }
            this.iterated = 0;
            ChunkedArrayQueue.this.poll();
        }
    }

    private static class Chunk<E> {
        final @Nullable E @NotNull [] values;
        int jumpIndex = -1;
        @Nullable
        Chunk<E> next;

        Chunk(int chunkSize) {
            this.values = new Object[chunkSize];
        }
    }
}

