/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
class ImmutableEmptyIntList
implements ImmutableIntList {
    @NotNull
    public static final ImmutableEmptyIntList INSTANCE = new ImmutableEmptyIntList();

    private ImmutableEmptyIntList() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int get(int index) {
        throw new IndexOutOfBoundsException("Empty int list");
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableIntList)) {
            return false;
        }
        return ((ImmutableIntList)o).size() == 0;
    }

    public int hashCode() {
        return 1;
    }

    @NotNull
    public String toString() {
        return "[]";
    }
}

