/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicLevel;
import com.hivemq.client.internal.util.ByteArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MqttTopicLevels
extends MqttTopicLevel {
    private final int firstEnd;

    @NotNull
    public static MqttTopicLevels concat(@NotNull MqttTopicLevel level1, @NotNull MqttTopicLevel level2) {
        byte[] array1 = level1.trim().getArray();
        byte[] array2 = level2.trim().getArray();
        byte[] array = new byte[array1.length + 1 + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        array[array1.length] = 47;
        System.arraycopy(array2, 0, array, array1.length + 1, array2.length);
        return new MqttTopicLevels(array, level1.length());
    }

    MqttTopicLevels(@NotNull byte[] array, int firstEnd) {
        super(array);
        this.firstEnd = firstEnd;
    }

    @Override
    protected int getEnd() {
        return this.firstEnd;
    }

    @NotNull
    public MqttTopicLevel before(int index) {
        if (index == this.array.length) {
            return this;
        }
        assert (this.array[index] == 47);
        if (index == this.firstEnd) {
            return MqttTopicLevel.of(this.array, 0, this.firstEnd);
        }
        return new MqttTopicLevels(Arrays.copyOfRange(this.array, 0, index), this.firstEnd);
    }

    @NotNull
    public MqttTopicLevel after(int index) {
        assert (this.array[index] == 47);
        int start = index + 1;
        int end = ByteArrayUtil.indexOf(this.array, start, (byte)47);
        if (end == this.array.length) {
            return MqttTopicLevel.of(this.array, start, this.array.length);
        }
        return new MqttTopicLevels(Arrays.copyOfRange(this.array, start, this.array.length), end - start);
    }
}

