/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.CallByThread;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.advanced.interceptor.MqttClientInterceptors;
import com.hivemq.client.internal.mqtt.handler.MqttSessionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishService;
import com.hivemq.client.internal.mqtt.ioc.ClientScope;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.publish.puback.MqttPubAck;
import com.hivemq.client.internal.mqtt.message.publish.puback.MqttPubAckBuilder;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubComp;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubCompBuilder;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRec;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRecBuilder;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import com.hivemq.client.internal.netty.ContextFuture;
import com.hivemq.client.internal.netty.DefaultContextPromise;
import com.hivemq.client.internal.util.collections.IntIndex;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos1.Mqtt5IncomingQos1Interceptor;
import com.hivemq.client.mqtt.mqtt5.advanced.interceptor.qos2.Mqtt5IncomingQos2Interceptor;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubcomp.Mqtt5PubCompReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrec.Mqtt5PubRecReasonCode;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

@ClientScope
public class MqttIncomingQosHandler
extends MqttSessionAwareHandler
implements ContextFuture.Listener<MqttMessage.WithId> {
    @NotNull
    public static final String NAME = "qos.incoming";
    @NotNull
    private static final IntIndex.Spec<MqttMessage.WithId> INDEX_SPEC = new IntIndex.Spec<MqttMessage.WithId>(MqttMessage.WithId::getPacketIdentifier);
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttIncomingPublishFlows incomingPublishFlows;
    @NotNull
    private final MqttIncomingPublishService incomingPublishService;
    @NotNull
    private final IntIndex<MqttMessage.WithId> messages = new IntIndex<MqttMessage.WithId>(INDEX_SPEC);
    private int receiveMaximum;

    @Inject
    MqttIncomingQosHandler(@NotNull MqttClientConfig clientConfig, @NotNull MqttIncomingPublishFlows incomingPublishFlows) {
        this.clientConfig = clientConfig;
        this.incomingPublishFlows = incomingPublishFlows;
        this.incomingPublishService = new MqttIncomingPublishService(this);
    }

    @Override
    public void onSessionStartOrResume(@NotNull MqttClientConnectionConfig connectionConfig, @NotNull EventLoop eventLoop) {
        super.onSessionStartOrResume(connectionConfig, eventLoop);
        this.receiveMaximum = connectionConfig.getReceiveMaximum();
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttStatefulPublish) {
            this.readPublish(ctx, (MqttStatefulPublish)msg);
        } else if (msg instanceof MqttPubRel) {
            this.readPubRel(ctx, (MqttPubRel)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readPublish(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        switch (((MqttPublish)publish.stateless()).getQos()) {
            case AT_MOST_ONCE: {
                this.readPublishQos0(publish);
                break;
            }
            case AT_LEAST_ONCE: {
                this.readPublishQos1(ctx, publish);
                break;
            }
            case EXACTLY_ONCE: {
                this.readPublishQos2(ctx, publish);
            }
        }
    }

    private void readPublishQos0(@NotNull MqttStatefulPublish publish) {
        this.incomingPublishService.onPublishQos0(publish, this.receiveMaximum);
    }

    private void readPublishQos1(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        MqttMessage.WithId prevMessage = this.messages.putIfAbsent(publish);
        if (prevMessage == null) {
            this.readNewPublishQos1Or2(ctx, publish);
        } else if (prevMessage instanceof MqttStatefulPublish && ((MqttPublish)((MqttStatefulPublish)prevMessage).stateless()).getQos() == MqttQos.AT_LEAST_ONCE) {
            this.checkDupFlagSet(ctx, publish);
        } else if (prevMessage instanceof MqttPubAck) {
            if (this.checkDupFlagSet(ctx, publish)) {
                this.writePubAck(ctx, (MqttPubAck)prevMessage);
            }
        } else {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "QoS 1 PUBLISH must not be received with the same packet identifier as a QoS 2 PUBLISH");
        }
    }

    private void readPublishQos2(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        MqttMessage.WithId prevMessage = this.messages.putIfAbsent(publish);
        if (prevMessage == null) {
            this.readNewPublishQos1Or2(ctx, publish);
        } else if (prevMessage instanceof MqttStatefulPublish && ((MqttPublish)((MqttStatefulPublish)prevMessage).stateless()).getQos() == MqttQos.EXACTLY_ONCE) {
            this.checkDupFlagSet(ctx, publish);
        } else if (prevMessage instanceof MqttPubRec) {
            if (this.checkDupFlagSet(ctx, publish)) {
                this.writePubRec(ctx, (MqttPubRec)prevMessage);
            }
        } else {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "QoS 2 PUBLISH must not be received with the same packet identifier as a QoS 1 PUBLISH");
        }
    }

    private void readNewPublishQos1Or2(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        if (!this.incomingPublishService.onPublishQos1Or2(publish, this.receiveMaximum)) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.RECEIVE_MAXIMUM_EXCEEDED, "Received more QoS 1 and/or 2 PUBLISHes than allowed by Receive Maximum");
        }
    }

    private boolean checkDupFlagSet(@NotNull ChannelHandlerContext ctx, @NotNull MqttStatefulPublish publish) {
        if (!publish.isDup()) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "DUP flag must be set for a resent QoS " + ((MqttPublish)publish.stateless()).getQos().getCode() + " PUBLISH");
            return false;
        }
        return true;
    }

    @CallByThread(value="Netty EventLoop")
    void ack(@NotNull MqttStatefulPublish publish) {
        switch (((MqttPublish)publish.stateless()).getQos()) {
            case AT_LEAST_ONCE: {
                MqttPubAck pubAck = this.buildPubAck(new MqttPubAckBuilder(publish));
                this.messages.put(pubAck);
                if (this.ctx == null) break;
                this.writePubAck(this.ctx, pubAck);
                break;
            }
            case EXACTLY_ONCE: {
                MqttPubRec pubRec = this.buildPubRec(new MqttPubRecBuilder(publish));
                this.messages.put(pubRec);
                if (this.ctx == null) break;
                this.writePubRec(this.ctx, pubRec);
            }
        }
    }

    private void writePubAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubAck pubAck) {
        ctx.writeAndFlush((Object)pubAck, new DefaultContextPromise<MqttPubAck>(ctx.channel(), pubAck)).addListener((GenericFutureListener)this);
    }

    private void writePubRec(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubRec pubRec) {
        if (((Mqtt5PubRecReasonCode)pubRec.getReasonCode()).isError()) {
            ctx.writeAndFlush((Object)pubRec, new DefaultContextPromise<MqttPubRec>(ctx.channel(), pubRec)).addListener((GenericFutureListener)this);
        } else {
            ctx.writeAndFlush((Object)pubRec, ctx.voidPromise());
        }
    }

    public void operationComplete(@NotNull ContextFuture<? extends MqttMessage.WithId> future) {
        if (future.isSuccess()) {
            this.messages.remove(future.getContext().getPacketIdentifier());
        } else {
            future.channel().pipeline().fireExceptionCaught(future.cause());
        }
    }

    private void readPubRel(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubRel pubRel) {
        MqttMessage.WithId prevMessage = this.messages.remove(pubRel.getPacketIdentifier());
        if (prevMessage instanceof MqttPubRec) {
            this.writePubComp(ctx, this.buildPubComp(new MqttPubCompBuilder(pubRel)));
        } else if (prevMessage == null) {
            this.writePubComp(ctx, this.buildPubComp(new MqttPubCompBuilder(pubRel).reasonCode(Mqtt5PubCompReasonCode.PACKET_IDENTIFIER_NOT_FOUND)));
        } else if (prevMessage instanceof MqttStatefulPublish && ((MqttPublish)((MqttStatefulPublish)prevMessage).stateless()).getQos() == MqttQos.EXACTLY_ONCE) {
            this.messages.put(prevMessage);
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBREL must not be received with the same packet identifier as a QoS 2 PUBLISH when no PUBREC has been sent yet");
        } else {
            this.messages.put(prevMessage);
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBREL must not be received with the same packet identifier as a QoS 1 PUBLISH");
        }
    }

    private void writePubComp(@NotNull ChannelHandlerContext ctx, @NotNull MqttPubComp pubComp) {
        ctx.writeAndFlush((Object)pubComp, ctx.voidPromise());
    }

    @Override
    public void onSessionEnd(@NotNull Throwable cause) {
        super.onSessionEnd(cause);
        this.incomingPublishFlows.clear(cause);
        this.messages.clear();
    }

    @NotNull
    private MqttPubAck buildPubAck(@NotNull MqttPubAckBuilder pubAckBuilder) {
        Mqtt5IncomingQos1Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getIncomingQos1Interceptor()) != null) {
            interceptor.onPublish(this.clientConfig, (Mqtt5Publish)pubAckBuilder.getPublish().stateless(), pubAckBuilder);
        }
        return pubAckBuilder.build();
    }

    @NotNull
    private MqttPubRec buildPubRec(@NotNull MqttPubRecBuilder pubRecBuilder) {
        Mqtt5IncomingQos2Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getIncomingQos2Interceptor()) != null) {
            interceptor.onPublish(this.clientConfig, (Mqtt5Publish)pubRecBuilder.getPublish().stateless(), pubRecBuilder);
        }
        return pubRecBuilder.build();
    }

    @NotNull
    private MqttPubComp buildPubComp(@NotNull MqttPubCompBuilder pubCompBuilder) {
        Mqtt5IncomingQos2Interceptor interceptor;
        MqttClientInterceptors interceptors = this.clientConfig.getAdvancedConfig().getInterceptors();
        if (interceptors != null && (interceptor = interceptors.getIncomingQos2Interceptor()) != null) {
            interceptor.onPubRel(this.clientConfig, pubCompBuilder.getPubRel(), pubCompBuilder);
        }
        return pubCompBuilder.build();
    }

    @NotNull
    MqttIncomingPublishFlows getIncomingPublishFlows() {
        return this.incomingPublishFlows;
    }

    @NotNull
    MqttIncomingPublishService getIncomingPublishService() {
        return this.incomingPublishService;
    }
}

