/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttMatchingPublishFlows;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscribedPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttSubscriptionFlows;
import com.hivemq.client.internal.util.collections.HandleList;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class MqttSubscriptionFlowList
implements MqttSubscriptionFlows {
    @NotNull
    private final HandleList<MqttSubscribedPublishFlow> flows = new HandleList();
    @NotNull
    private final HashMap<MqttTopicFilterImpl, Integer> subscribedTopicFilters = new HashMap();

    @Inject
    MqttSubscriptionFlowList() {
    }

    @Override
    public void subscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        Integer count;
        if (flow != null) {
            HandleList<MqttTopicFilterImpl> topicFilters = flow.getTopicFilters();
            if (topicFilters.isEmpty()) {
                this.flows.add(flow);
            }
            topicFilters.add(topicFilter);
        }
        if ((count = this.subscribedTopicFilters.put(topicFilter, 1)) != null) {
            this.subscribedTopicFilters.put(topicFilter, count + 1);
        }
    }

    @Override
    public void remove(@NotNull MqttTopicFilterImpl topicFilter, @Nullable MqttSubscribedPublishFlow flow) {
        Integer count;
        if (flow != null) {
            HandleList<MqttTopicFilterImpl> topicFilters = flow.getTopicFilters();
            for (HandleList.Handle h = (HandleList.Handle)topicFilters.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
                if (!topicFilter.equals(h.getElement())) continue;
                topicFilters.remove(h);
                break;
            }
            if (topicFilters.isEmpty()) {
                this.cancel(flow);
            }
        }
        if ((count = this.subscribedTopicFilters.remove(topicFilter)) != null && count > 1) {
            this.subscribedTopicFilters.put(topicFilter, count - 1);
        }
    }

    @Override
    public void unsubscribe(@NotNull MqttTopicFilterImpl topicFilter, @Nullable Consumer<MqttSubscribedPublishFlow> unsubscribedCallback) {
        for (HandleList.Handle h = (HandleList.Handle)this.flows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
            MqttSubscribedPublishFlow flow = (MqttSubscribedPublishFlow)h.getElement();
            HandleList<MqttTopicFilterImpl> topicFilters = flow.getTopicFilters();
            for (HandleList.Handle h2 = (HandleList.Handle)topicFilters.getFirst(); h2 != null; h2 = (HandleList.Handle)h2.getNext()) {
                if (!topicFilter.equals(h2.getElement())) continue;
                topicFilters.remove(h2);
            }
            if (!topicFilters.isEmpty()) continue;
            this.flows.remove(h);
            flow.onComplete();
            if (unsubscribedCallback == null) continue;
            unsubscribedCallback.accept(flow);
        }
        this.subscribedTopicFilters.remove(topicFilter);
    }

    @Override
    public void cancel(@NotNull MqttSubscribedPublishFlow flow) {
        for (HandleList.Handle h = (HandleList.Handle)this.flows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
            if (h.getElement() != flow) continue;
            this.flows.remove(h);
            break;
        }
    }

    @Override
    public void findMatching(@NotNull MqttTopicImpl topic, @NotNull MqttMatchingPublishFlows matchingFlows) {
        block0: for (HandleList.Handle h = (HandleList.Handle)this.flows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
            MqttSubscribedPublishFlow flow = (MqttSubscribedPublishFlow)h.getElement();
            for (HandleList.Handle h2 = (HandleList.Handle)flow.getTopicFilters().getFirst(); h2 != null; h2 = (HandleList.Handle)h2.getNext()) {
                if (!((MqttTopicFilterImpl)h2.getElement()).matches(topic)) continue;
                matchingFlows.add(flow);
                continue block0;
            }
        }
        if (!matchingFlows.isEmpty()) {
            matchingFlows.subscriptionFound = true;
            return;
        }
        for (MqttTopicFilterImpl subscribedTopicFilter : this.subscribedTopicFilters.keySet()) {
            if (!subscribedTopicFilter.matches(topic)) continue;
            matchingFlows.subscriptionFound = true;
            return;
        }
    }

    @Override
    public void clear(@NotNull Throwable cause) {
        for (HandleList.Handle h = (HandleList.Handle)this.flows.getFirst(); h != null; h = (HandleList.Handle)h.getNext()) {
            ((MqttSubscribedPublishFlow)h.getElement()).onError(cause);
        }
        this.flows.clear();
        this.subscribedTopicFilters.clear();
    }
}

