/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.util;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import io.netty.channel.EventLoop;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class FlowWithEventLoop {
    private static final int STATE_INIT = 0;
    private static final int STATE_NOT_DONE = 1;
    private static final int STATE_DONE = 2;
    private static final int STATE_CANCELLED = 3;
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    protected final EventLoop eventLoop;
    @NotNull
    private final AtomicInteger doneState = new AtomicInteger(0);

    public FlowWithEventLoop(@NotNull MqttClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.eventLoop = clientConfig.acquireEventLoop();
    }

    public boolean init() {
        if (this.doneState.getAndSet(1) == 3) {
            this.clientConfig.releaseEventLoop();
            return false;
        }
        return true;
    }

    protected boolean setDone() {
        if (this.doneState.compareAndSet(1, 2)) {
            this.clientConfig.releaseEventLoop();
            return true;
        }
        return false;
    }

    public void cancel() {
        if (this.doneState.getAndSet(3) == 1) {
            this.onCancel();
            this.clientConfig.releaseEventLoop();
        }
    }

    public void dispose() {
        this.cancel();
    }

    protected void onCancel() {
    }

    public boolean isCancelled() {
        return this.doneState.get() == 3;
    }

    public boolean isDisposed() {
        int doneState = this.doneState.get();
        return doneState == 2 || doneState == 3;
    }

    @NotNull
    public EventLoop getEventLoop() {
        return this.eventLoop;
    }
}

