/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.websocket;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.handler.MqttChannelInitializer;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketCodec;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConnectionScope
public class MqttWebSocketInitializer
extends ChannelInboundHandlerAdapter {
    @NotNull
    private static final String NAME = "ws.init";
    @NotNull
    private static final String HTTP_CODEC_NAME = "http.codec";
    @NotNull
    private static final String HTTP_AGGREGATOR_NAME = "http.aggregator";
    @NotNull
    private static final String WEBSOCKET_URI_SCHEME = "ws";
    @NotNull
    private static final String WEBSOCKET_TLS_URI_SCHEME = "wss";
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttChannelInitializer mqttChannelInitializer;
    @NotNull
    private final MqttWebSocketCodec mqttWebSocketCodec;
    @Nullable
    private WebSocketClientHandshaker handshaker;

    @Inject
    MqttWebSocketInitializer(@NotNull MqttClientConfig clientConfig, @NotNull MqttChannelInitializer mqttChannelInitializer, @NotNull MqttWebSocketCodec mqttWebSocketCodec) {
        this.clientConfig = clientConfig;
        this.mqttChannelInitializer = mqttChannelInitializer;
        this.mqttWebSocketCodec = mqttWebSocketCodec;
    }

    public void initChannel(@NotNull Channel channel, @NotNull MqttWebSocketConfigImpl webSocketConfig) throws URISyntaxException {
        URI uri = new URI(this.clientConfig.getTransportConfig().getRawSslConfig() == null ? WEBSOCKET_URI_SCHEME : WEBSOCKET_TLS_URI_SCHEME, null, this.clientConfig.getServerHost(), this.clientConfig.getServerPort(), "/" + webSocketConfig.getServerPath(), null, null);
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)webSocketConfig.getSubprotocol(), (boolean)true, null, (int)0x10000004, (boolean)true, (boolean)false);
        channel.pipeline().addLast(HTTP_CODEC_NAME, (ChannelHandler)new HttpClientCodec()).addLast(HTTP_AGGREGATOR_NAME, (ChannelHandler)new HttpObjectAggregator(65535)).addLast(NAME, (ChannelHandler)this).addLast("ws.mqtt", (ChannelHandler)this.mqttWebSocketCodec);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        assert (this.handshaker != null);
        ctx.fireChannelActive();
        this.handshaker.handshake(ctx.channel(), ctx.voidPromise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        assert (this.handshaker != null);
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            try {
                if (this.handshaker.isHandshakeComplete()) {
                    throw new IllegalStateException("Must not receive http response if websocket handshake is already finished.");
                }
                this.handshaker.finishHandshake(ctx.channel(), response);
                this.mqttChannelInitializer.initMqtt(ctx.channel());
                ctx.pipeline().remove((ChannelHandler)this);
            }
            finally {
                response.release();
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        this.mqttChannelInitializer.exceptionCaught(ctx, cause);
    }

    public boolean isSharable() {
        return false;
    }
}

