/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.lifecycle;

import com.hivemq.client.internal.mqtt.lifecycle.MqttClientAutoReconnectImplBuilder;
import com.hivemq.client.mqtt.lifecycle.MqttClientAutoReconnect;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientReconnector;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MqttClientAutoReconnectImpl
implements MqttClientAutoReconnect {
    static final long DEFAULT_START_DELAY_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    static final long DEFAULT_MAX_DELAY_NANOS = TimeUnit.NANOSECONDS.convert(120L, TimeUnit.SECONDS);
    @NotNull
    public static final MqttClientAutoReconnectImpl DEFAULT = new MqttClientAutoReconnectImpl(DEFAULT_START_DELAY_NANOS, DEFAULT_MAX_DELAY_NANOS);
    private final long initialDelayNanos;
    private final long maxDelayNanos;

    MqttClientAutoReconnectImpl(long initialDelayNanos, long maxDelayNanos) {
        this.initialDelayNanos = initialDelayNanos;
        this.maxDelayNanos = maxDelayNanos;
    }

    @Override
    public void onDisconnected(@NotNull MqttClientDisconnectedContext context) {
        if (context.getSource() != MqttDisconnectSource.USER) {
            MqttClientReconnector reconnector = context.getReconnector();
            long delay = (long)Math.min((double)this.initialDelayNanos * Math.pow(2.0, reconnector.getAttempts()), (double)this.maxDelayNanos);
            long randomDelay = (long)((double)delay / 4.0 / 2.147483647E9 * (double)ThreadLocalRandom.current().nextInt());
            reconnector.reconnect(true).delay(delay + randomDelay, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long getInitialDelay(@NotNull TimeUnit timeUnit) {
        return timeUnit.convert(this.initialDelayNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getMaxDelay(@NotNull TimeUnit timeUnit) {
        return timeUnit.convert(this.maxDelayNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public MqttClientAutoReconnectImplBuilder.Default extend() {
        return new MqttClientAutoReconnectImplBuilder.Default(this);
    }
}

