/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PayloadFormatIndicator;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5WillPublishBuilder;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttPublishBuilder<B extends MqttPublishBuilder<B>> {
    @Nullable
    MqttTopicImpl topic;
    @Nullable
    ByteBuffer payload;
    @NotNull
    MqttQos qos = MqttPublish.DEFAULT_QOS;
    boolean retain;
    long messageExpiryInterval = Long.MAX_VALUE;
    @Nullable
    Mqtt5PayloadFormatIndicator payloadFormatIndicator;
    @Nullable
    MqttUtf8StringImpl contentType;
    @Nullable
    MqttTopicImpl responseTopic;
    @Nullable
    ByteBuffer correlationData;
    @NotNull
    MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    MqttPublishBuilder() {
    }

    MqttPublishBuilder(@NotNull MqttPublish publish) {
        this.topic = publish.getTopic();
        this.payload = publish.getRawPayload();
        this.qos = publish.getQos();
        this.retain = publish.isRetain();
        this.messageExpiryInterval = publish.getRawMessageExpiryInterval();
        this.payloadFormatIndicator = publish.getRawPayloadFormatIndicator();
        this.contentType = publish.getRawContentType();
        this.responseTopic = publish.getRawResponseTopic();
        this.correlationData = publish.getRawCorrelationData();
        this.userProperties = publish.getUserProperties();
    }

    MqttPublishBuilder(@NotNull MqttPublishBuilder<?> publishBuilder) {
        this.topic = publishBuilder.topic;
        this.payload = publishBuilder.payload;
        this.qos = publishBuilder.qos;
        this.retain = publishBuilder.retain;
        this.messageExpiryInterval = publishBuilder.messageExpiryInterval;
        this.payloadFormatIndicator = publishBuilder.payloadFormatIndicator;
        this.contentType = publishBuilder.contentType;
        this.responseTopic = publishBuilder.responseTopic;
        this.correlationData = publishBuilder.correlationData;
        this.userProperties = publishBuilder.userProperties;
    }

    @NotNull
    abstract B self();

    @NotNull
    public B topic(@Nullable String topic) {
        this.topic = MqttTopicImpl.of(topic);
        return this.self();
    }

    @NotNull
    public B topic(@Nullable MqttTopic topic) {
        this.topic = MqttChecks.topic(topic);
        return this.self();
    }

    @NotNull
    public MqttTopicImplBuilder.Nested<B> topic() {
        return new MqttTopicImplBuilder.Nested<MqttPublishBuilder>(this::topic);
    }

    @NotNull
    public B qos(@Nullable MqttQos qos) {
        this.qos = Checks.notNull(qos, "QoS");
        return this.self();
    }

    @NotNull
    public B retain(boolean retain) {
        this.retain = retain;
        return this.self();
    }

    @NotNull
    public B messageExpiryInterval(long messageExpiryInterval) {
        this.messageExpiryInterval = Checks.unsignedInt(messageExpiryInterval, "Message expiry interval");
        return this.self();
    }

    @NotNull
    public B noMessageExpiry() {
        this.messageExpiryInterval = Long.MAX_VALUE;
        return this.self();
    }

    @NotNull
    public B payloadFormatIndicator(@Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator) {
        this.payloadFormatIndicator = payloadFormatIndicator;
        return this.self();
    }

    @NotNull
    public B contentType(@Nullable String contentType) {
        this.contentType = MqttChecks.stringOrNull(contentType, "Content type");
        return this.self();
    }

    @NotNull
    public B contentType(@Nullable MqttUtf8String contentType) {
        this.contentType = MqttChecks.stringOrNull(contentType, "Content type");
        return this.self();
    }

    @NotNull
    public B responseTopic(@Nullable String responseTopic) {
        this.responseTopic = responseTopic == null ? null : MqttTopicImpl.of(responseTopic, "Response topic");
        return this.self();
    }

    @NotNull
    public B responseTopic(@Nullable MqttTopic responseTopic) {
        this.responseTopic = Checks.notImplementedOrNull(responseTopic, MqttTopicImpl.class, "Response topic");
        return this.self();
    }

    @NotNull
    public MqttTopicImplBuilder.Nested<B> responseTopic() {
        return new MqttTopicImplBuilder.Nested<MqttPublishBuilder>(this::responseTopic);
    }

    @NotNull
    public B correlationData(@Nullable byte[] correlationData) {
        this.correlationData = MqttChecks.binaryDataOrNull(correlationData, "Correlation data");
        return this.self();
    }

    @NotNull
    public B correlationData(@Nullable ByteBuffer correlationData) {
        this.correlationData = MqttChecks.binaryDataOrNull(correlationData, "Correlation data");
        return this.self();
    }

    @NotNull
    public B userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this.self();
    }

    @NotNull
    public MqttUserPropertiesImplBuilder.Nested<B> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttPublishBuilder>(this.userProperties, this::userProperties);
    }

    public static class WillNested<P>
    extends WillBase<WillNested<P>>
    implements Mqtt5WillPublishBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super MqttWillPublish, P> parentConsumer;

        public WillNested(@NotNull Function<? super MqttWillPublish, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        WillNested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyWillPublish() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class WillDefault
    extends WillBase<WillDefault>
    implements Mqtt5WillPublishBuilder.Complete {
        public WillDefault() {
        }

        WillDefault(@NotNull MqttPublish publish) {
            super(publish);
        }

        WillDefault(@NotNull MqttPublishBuilder<?> publishBuilder) {
            super(publishBuilder);
        }

        @Override
        @NotNull
        WillDefault self() {
            return this;
        }
    }

    private static abstract class WillBase<B extends WillBase<B>>
    extends MqttPublishBuilder<B> {
        private long delayInterval = 0L;

        WillBase() {
        }

        WillBase(@NotNull MqttPublish publish) {
            super(publish);
            if (publish instanceof MqttWillPublish) {
                this.delayInterval = ((MqttWillPublish)publish).getDelayInterval();
            } else {
                this.payload(this.payload);
            }
        }

        WillBase(@NotNull MqttPublishBuilder<?> publishBuilder) {
            super(publishBuilder);
            if (publishBuilder instanceof WillBase) {
                this.delayInterval = ((WillBase)publishBuilder).delayInterval;
            } else {
                this.payload(this.payload);
            }
        }

        @NotNull
        public B payload(@Nullable byte[] payload) {
            this.payload = MqttChecks.binaryDataOrNull(payload, "Payload");
            return (B)((WillBase)this.self());
        }

        @NotNull
        public B payload(@Nullable ByteBuffer payload) {
            this.payload = MqttChecks.binaryDataOrNull(payload, "Payload");
            return (B)((WillBase)this.self());
        }

        @NotNull
        public B delayInterval(long delayInterval) {
            this.delayInterval = Checks.unsignedInt(delayInterval, "Will delay interval");
            return (B)((WillBase)this.self());
        }

        @NotNull
        public MqttWillPublish build() {
            Checks.notNull(this.topic, "Topic");
            return new MqttWillPublish(this.topic, this.payload, this.qos, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.userProperties, this.delayInterval);
        }
    }

    public static class Send<P>
    extends Base<Send<P>>
    implements Mqtt5PublishBuilder.Send.Complete<P> {
        @NotNull
        private final Function<? super MqttPublish, P> parentConsumer;

        public Send(@NotNull Function<? super MqttPublish, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends Base<Nested<P>>
    implements Mqtt5PublishBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super MqttPublish, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttPublish, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyPublish() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Base<Default>
    implements Mqtt5PublishBuilder.Complete {
        public Default() {
        }

        Default(@NotNull MqttPublish publish) {
            super(publish);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }

    private static abstract class Base<B extends Base<B>>
    extends MqttPublishBuilder<B> {
        Base() {
        }

        Base(@NotNull MqttPublish publish) {
            super(publish);
        }

        @NotNull
        public B payload(@Nullable byte[] payload) {
            this.payload = ByteBufferUtil.wrap(payload);
            return (B)((Base)this.self());
        }

        @NotNull
        public B payload(@Nullable ByteBuffer payload) {
            this.payload = ByteBufferUtil.slice(payload);
            return (B)((Base)this.self());
        }

        @NotNull
        public WillDefault asWill() {
            return new WillDefault(this);
        }

        @NotNull
        public MqttPublish build() {
            Checks.notNull(this.topic, "Topic");
            return new MqttPublish(this.topic, this.payload, this.qos, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.userProperties);
        }
    }
}

