/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublishBuilder;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PayloadFormatIndicator;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5WillPublish;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class MqttWillPublish
extends MqttPublish
implements Mqtt5WillPublish {
    private final long delayInterval;

    public MqttWillPublish(@NotNull MqttTopicImpl topic, @Nullable ByteBuffer payload, @NotNull MqttQos qos, boolean isRetain, long messageExpiryInterval, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, @Nullable MqttUtf8StringImpl contentType, @Nullable MqttTopicImpl responseTopic, @Nullable ByteBuffer correlationData, @NotNull MqttUserPropertiesImpl userProperties, long delayInterval) {
        super(topic, payload, qos, isRetain, messageExpiryInterval, payloadFormatIndicator, contentType, responseTopic, correlationData, userProperties);
        this.delayInterval = delayInterval;
    }

    @Override
    public long getDelayInterval() {
        return this.delayInterval;
    }

    @Override
    @NotNull
    public MqttWillPublish asWill() {
        return this;
    }

    @Override
    @NotNull
    public MqttPublishBuilder.WillDefault extendAsWill() {
        return new MqttPublishBuilder.WillDefault(this);
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return super.toAttributeString() + ", delayInterval=" + this.delayInterval;
    }

    @Override
    @NotNull
    public String toString() {
        return "MqttWillPublish{" + this.toAttributeString() + '}';
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttWillPublish) || !super.equals(o)) {
            return false;
        }
        MqttWillPublish that = (MqttWillPublish)o;
        return this.delayInterval == that.delayInterval;
    }

    @Override
    protected boolean canEqual(@Nullable Object o) {
        return o instanceof MqttWillPublish;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.delayInterval);
        return result;
    }
}

