/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.proxy;

import com.hivemq.client.internal.mqtt.MqttProxyConfigImpl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MqttProxyAdapterHandler
extends ChannelOutboundHandlerAdapter {
    @NotNull
    public static final String NAME = "proxy.adapter";
    @NotNull
    private static final String PROXY_HANDLER_NAME = "proxy";
    @NotNull
    private final MqttProxyConfigImpl proxyConfig;
    @NotNull
    private final InetSocketAddress serverAddress;
    @NotNull
    private final Consumer<Channel> onSuccess;
    @NotNull
    private final BiConsumer<Channel, Throwable> onError;

    public MqttProxyAdapterHandler(@NotNull MqttProxyConfigImpl proxyConfig, @NotNull InetSocketAddress serverAddress, @NotNull Consumer<Channel> onSuccess, @NotNull BiConsumer<Channel, Throwable> onError) {
        this.proxyConfig = proxyConfig;
        this.serverAddress = serverAddress;
        this.onSuccess = onSuccess;
        this.onError = onError;
    }

    public void connect(@NotNull ChannelHandlerContext ctx, @NotNull SocketAddress remoteAddress, @Nullable SocketAddress localAddress, @NotNull ChannelPromise promise) {
        Socks4ProxyHandler proxyHandler;
        Channel channel = ctx.channel();
        String username = this.proxyConfig.getRawUsername();
        String password = this.proxyConfig.getRawPassword();
        Consumer<Channel> onSuccess = this.onSuccess;
        BiConsumer<Channel, Throwable> onError = this.onError;
        switch (this.proxyConfig.getProtocol()) {
            case SOCKS_4: {
                proxyHandler = new Socks4ProxyHandler(remoteAddress, username);
                break;
            }
            case SOCKS_5: {
                proxyHandler = new Socks5ProxyHandler(remoteAddress, username, password);
                break;
            }
            case HTTP: {
                if (username == null && password == null) {
                    proxyHandler = new HttpProxyHandler(remoteAddress);
                    break;
                }
                proxyHandler = new HttpProxyHandler(remoteAddress, username == null ? "" : username, password == null ? "" : password);
                break;
            }
            default: {
                onError.accept(channel, new IllegalStateException("Unknown proxy protocol " + (Object)((Object)this.proxyConfig.getProtocol())));
                return;
            }
        }
        proxyHandler.setConnectTimeoutMillis((long)this.proxyConfig.getHandshakeTimeoutMs());
        proxyHandler.connectFuture().addListener(future -> {
            channel.pipeline().remove(PROXY_HANDLER_NAME);
            if (future.isSuccess()) {
                onSuccess.accept(channel);
            } else {
                onError.accept(channel, future.cause());
            }
        });
        channel.pipeline().addFirst(PROXY_HANDLER_NAME, (ChannelHandler)proxyHandler).remove((ChannelHandler)this);
        ctx.connect((SocketAddress)this.serverAddress, localAddress, promise);
    }

    public boolean isSharable() {
        return false;
    }
}

