/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.testcontainer.core;

import com.hivemq.extension.sdk.api.ExtensionMain;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import org.testcontainers.shaded.com.google.common.collect.ImmutableList;

public class HiveMQExtension {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    private final int priority;
    private final int startPriority;
    private final boolean sign;
    private final boolean disabledOnStartup;
    @NotNull
    private final Class<? extends ExtensionMain> mainClass;
    @NotNull
    private final ImmutableList<Class<?>> additionalClasses;

    private HiveMQExtension(@NotNull String id, @NotNull String name, @NotNull String version, int priority, int startPriority, boolean sign, boolean disabledOnStartup, @NotNull Class<? extends ExtensionMain> mainClass, @NotNull ImmutableList<Class<?>> additionalClasses) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.priority = priority;
        this.startPriority = startPriority;
        this.sign = sign;
        this.disabledOnStartup = disabledOnStartup;
        this.mainClass = mainClass;
        this.additionalClasses = additionalClasses;
    }

    public static Builder newHiveMQExtension() {
        return new Builder();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getStartPriority() {
        return this.startPriority;
    }

    public boolean sign() {
        return this.sign;
    }

    public boolean isDisabledOnStartup() {
        return this.disabledOnStartup;
    }

    @NotNull
    public Class<? extends ExtensionMain> getMainClass() {
        return this.mainClass;
    }

    @NotNull
    public ImmutableList<Class<?>> getAdditionalClasses() {
        return this.additionalClasses;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String version;
        private int priority = 0;
        private int startPriority = 0;
        private boolean sign = false;
        private boolean disabledOnStartup = false;
        @Nullable
        private Class<? extends ExtensionMain> mainClass;
        @NotNull
        private final ImmutableList.Builder<Class<?>> additionalClassesBuilder = ImmutableList.builder();

        public HiveMQExtension build() {
            if (this.id == null || this.id.isEmpty()) {
                throw new IllegalArgumentException("extension id must not be null or empty");
            }
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("extension name must not be null or empty");
            }
            if (this.version == null || this.version.isEmpty()) {
                throw new IllegalArgumentException("extension version must not be null or empty");
            }
            if (this.mainClass == null) {
                throw new IllegalArgumentException("extension main class must not be null");
            }
            return new HiveMQExtension(this.id, this.name, this.version, this.priority, this.startPriority, this.sign, this.disabledOnStartup, this.mainClass, this.additionalClassesBuilder.build());
        }

        @NotNull
        public Builder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public Builder version(@NotNull String version) {
            this.version = version;
            return this;
        }

        @NotNull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @NotNull
        public Builder startPriority(int startPriority) {
            this.startPriority = startPriority;
            return this;
        }

        @NotNull
        public Builder disabledOnStartup(boolean disabledOnStartup) {
            this.disabledOnStartup = disabledOnStartup;
            return this;
        }

        @NotNull
        public Builder sign(boolean sign) {
            this.sign = sign;
            return this;
        }

        @NotNull
        public Builder mainClass(@NotNull Class<? extends ExtensionMain> mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        @NotNull
        public Builder addAdditionalClass(@NotNull Class<?> clazz) {
            this.additionalClassesBuilder.add(clazz);
            return this;
        }
    }
}

