/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.testcontainer.core;

import com.hivemq.client.mqtt.mqtt5.Mqtt5Client;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.Mqtt5RxClient;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import io.reactivex.CompletableSource;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;

public class MqttWaitStrategy
extends AbstractWaitStrategy {
    @NotNull
    private Duration retryInterval = Duration.ofMillis(500L);
    @NotNull
    private Duration initialWaitDuration = Duration.ofSeconds(5L);

    protected void waitUntilReady() {
        Integer mappedMqttPort = this.waitStrategyTarget.getMappedPort(1883);
        Mqtt5RxClient retryClient = ((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)Mqtt5Client.builder().identifier("retry-client")).serverPort(mappedMqttPort.intValue())).serverHost("localhost")).buildRx();
        try {
            Thread.sleep(this.initialWaitDuration.toMillis());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        retryClient.connect().retryWhen(flowable -> flowable.delay(this.retryInterval.toNanos(), TimeUnit.NANOSECONDS)).timeout(this.startupTimeout.getSeconds(), TimeUnit.SECONDS).ignoreElement().andThen((CompletableSource)retryClient.disconnect()).blockingAwait();
    }

    @NotNull
    public MqttWaitStrategy withRetryInterval(@NotNull Duration retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    @NotNull
    public MqttWaitStrategy withInitialWait(@NotNull Duration initialWaitDuration) {
        this.initialWaitDuration = initialWaitDuration;
        return this;
    }
}

