/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.testcontainer.core;

import com.hivemq.extension.sdk.api.ExtensionMain;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.testcontainer.core.HiveMQExtension;
import com.hivemq.testcontainer.core.MultiLogMessageWaitStrategy;
import com.hivemq.testcontainer.core.PathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javassist.ClassPool;
import javassist.NotFoundException;
import org.apache.commons.io.FileUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.google.common.io.Files;
import org.testcontainers.utility.MountableFile;

public class HiveMQTestContainerCore<SELF extends HiveMQTestContainerCore<SELF>>
extends FixedHostPortGenericContainer<SELF> {
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(HiveMQTestContainerCore.class);
    @NotNull
    private static final String validPluginXML = "<hivemq-extension>   <id>%s</id>   <name>%s</name>   <version>%s</version>   <priority>%s</priority>   <start-priority>%s</start-priority></hivemq-extension>";
    @NotNull
    private static final String DEFAULT_HIVEMQ_IMAGE = "hivemq/hivemq-ce";
    @NotNull
    private static final String DEFAULT_HIVEMQ_TAG = "latest";
    public static final int DEBUGGING_PORT = 9000;
    public static final int MQTT_PORT = 1883;
    public static final int CONTROL_CENTER_PORT = 8080;
    public static final int MODE = 511;
    @NotNull
    private final ConcurrentHashMap<String, CountDownLatch> containerOutputLatches = new ConcurrentHashMap();
    private volatile boolean silent = false;
    @NotNull
    private final MultiLogMessageWaitStrategy waitStrategy = new MultiLogMessageWaitStrategy();

    public HiveMQTestContainerCore() {
        this(DEFAULT_HIVEMQ_IMAGE, DEFAULT_HIVEMQ_TAG);
    }

    public HiveMQTestContainerCore(@NotNull String image, @NotNull String tag) {
        super(image + ":" + tag);
        this.addExposedPort(1883);
        this.waitStrategy.withRegEx("(.*)Started HiveMQ in(.*)");
        this.waitingFor((WaitStrategy)this.waitStrategy);
        this.withLogConsumer(outputFrame -> {
            if (!this.silent) {
                System.out.print(outputFrame.getUtf8String());
            }
        });
        this.withLogConsumer(outputFrame -> {
            if (!this.containerOutputLatches.isEmpty()) {
                this.containerOutputLatches.forEach((regEx, latch) -> {
                    if (outputFrame.getUtf8String().matches("(?s)" + regEx)) {
                        logger.debug("Container Output '{}' matched RegEx '{}'", (Object)outputFrame.getUtf8String(), regEx);
                        latch.countDown();
                    } else {
                        logger.debug("Container Output '{}' did not match RegEx '{}'", (Object)outputFrame.getUtf8String(), regEx);
                    }
                });
            }
        });
    }

    @NotNull
    public SELF waitForExtension(@NotNull String extensionName) {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) started successfully(.*)";
        this.waitStrategy.withRegEx(regEX);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF waitForExtension(@NotNull HiveMQExtension extension) {
        return this.waitForExtension(extension.getName());
    }

    @NotNull
    public SELF withDebugging(int debuggingPortHost) {
        this.addExposedPorts(new int[]{9000});
        this.addFixedExposedPort(debuggingPortHost, 9000);
        this.withEnv("JAVA_OPTS", "-agentlib:jdwp=transport=dt_socket,address=0.0.0.0:9000,server=y,suspend=n");
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withDebugging() {
        this.withDebugging(9000);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withLogLevel(@NotNull Level level) {
        this.withEnv("HIVEMQ_LOG_LEVEL", level.name());
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withExtension(@NotNull HiveMQExtension hiveMQExtension) {
        try {
            File extension = this.createExtension(hiveMQExtension);
            MountableFile mountableExtension = MountableFile.forHostPath((String)extension.getPath(), (Integer)511);
            this.withCopyFileToContainer(mountableExtension, "/opt/hivemq/extensions/" + hiveMQExtension.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withExtension(@NotNull File extensionDir) {
        if (!extensionDir.exists()) {
            logger.warn("Extension {} could not be mounted. It does not exist", (Object)extensionDir.getAbsolutePath());
            return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
        }
        if (!extensionDir.isDirectory()) {
            logger.warn("Extension {} could not be mounted. It is not a directory.", (Object)extensionDir.getAbsolutePath());
            return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
        }
        try {
            MountableFile mountableExtension = MountableFile.forHostPath((String)extensionDir.getPath(), (Integer)511);
            String containerPath = "/opt/hivemq/extensions/" + extensionDir.getName();
            this.withCopyFileToContainer(mountableExtension, containerPath);
            logger.info("Putting extension {} into {}", (Object)extensionDir.getName(), (Object)containerPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    private File createExtension(@NotNull HiveMQExtension hiveMQExtension) throws Exception {
        File disabled;
        boolean newFile22;
        File tempDir = Files.createTempDir();
        File extensionDir = new File(tempDir, hiveMQExtension.getId());
        FileUtils.writeStringToFile((File)new File(extensionDir, "hivemq-extension.xml"), (String)String.format(validPluginXML, hiveMQExtension.getId(), hiveMQExtension.getName(), hiveMQExtension.getVersion(), hiveMQExtension.getPriority(), hiveMQExtension.getStartPriority()), (Charset)Charset.defaultCharset());
        if (hiveMQExtension.isDisabledOnStartup() && !(newFile22 = (disabled = new File(extensionDir, "DISABLED")).createNewFile())) {
            logger.warn("Could not create DISABLED file {} on host machine", (Object)disabled.getAbsolutePath());
        }
        JavaArchive javaArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsServiceProviderAndClasses(ExtensionMain.class, new Class[]{hiveMQExtension.getMainClass()});
        try {
            this.putSubclassesIntoJar(hiveMQExtension.getId(), hiveMQExtension.getMainClass(), javaArchive);
            for (Class additionalClass : hiveMQExtension.getAdditionalClasses()) {
                this.putSubclassesIntoJar(hiveMQExtension.getId(), additionalClass, javaArchive);
            }
        }
        catch (Exception newFile22) {
            // empty catch block
        }
        ((ZipExporter)javaArchive.as(ZipExporter.class)).exportTo(new File(extensionDir, "extension.jar"));
        File jar = new File(extensionDir, "extension.jar");
        if (hiveMQExtension.sign()) {
            this.signExtension(hiveMQExtension.getId(), jar);
        }
        return extensionDir;
    }

    private void putSubclassesIntoJar(@NotNull String extensionId, @Nullable Class<?> clazz, @NotNull JavaArchive javaArchive) throws NotFoundException {
        if (clazz != null) {
            Set subClassNames = ClassPool.getDefault().get(clazz.getName()).getClassFile().getConstPool().getClassNames();
            for (String subClassName : subClassNames) {
                String className = subClassName.replaceAll("/", ".");
                logger.debug("Packaging subclass {} into extension {}.", (Object)className, (Object)extensionId);
                javaArchive.addClass(className);
            }
        }
    }

    @NotNull
    public SELF withLicense(@NotNull File license) {
        if (!license.exists()) {
            logger.warn("License file {} does not exist.", (Object)license.getAbsolutePath());
            return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
        }
        if (!license.getName().endsWith(".lic") && !license.getName().endsWith(".elic")) {
            logger.warn("License file {} does not end wit '.lic' or '.elic'", (Object)license.getAbsolutePath());
            return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
        }
        MountableFile mountableFile = MountableFile.forHostPath((String)license.getAbsolutePath(), (Integer)511);
        String containerPath = "/opt/hivemq/license/" + license.getName();
        this.withCopyFileToContainer(mountableFile, containerPath);
        logger.info("Putting license {} into {}", (Object)license.getAbsolutePath(), (Object)containerPath);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withHiveMQConfig(@NotNull File config) {
        if (!config.exists()) {
            logger.warn("HiveMQ config file {} does not exist.", (Object)config.getAbsolutePath());
            return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
        }
        MountableFile mountableFile = MountableFile.forHostPath((String)config.getAbsolutePath(), (Integer)511);
        String containerPath = "/opt/hivemq/conf/config.xml";
        this.withCopyFileToContainer(mountableFile, "/opt/hivemq/conf/config.xml");
        logger.info("Putting {} into {}", (Object)config.getAbsolutePath(), (Object)"/opt/hivemq/conf/config.xml");
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withFileInExtensionHomeFolder(@NotNull File file, @NotNull String extensionId) {
        return this.withFileInExtensionHomeFolder(file, extensionId, "");
    }

    @NotNull
    public SELF withFileInExtensionHomeFolder(@NotNull File file, @NotNull String extensionId, @NotNull String pathInExtensionHome) {
        return this.withFileInHomeFolder(file, "/extensions/" + extensionId + PathUtil.preparePath(pathInExtensionHome));
    }

    @NotNull
    public SELF withFileInHomeFolder(@NotNull File file) {
        return this.withFileInHomeFolder(file, "");
    }

    @NotNull
    public SELF withFileInHomeFolder(@NotNull File file, @NotNull String pathInHomeFolder) {
        if (!file.exists()) {
            logger.warn("File {} does not exist.", (Object)file.getAbsolutePath());
            return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
        }
        MountableFile mountableFile = MountableFile.forHostPath((String)file.getAbsolutePath(), (Integer)511);
        String containerPath = "/opt/hivemq" + PathUtil.preparePath(pathInHomeFolder) + file.getName();
        this.withCopyFileToContainer(mountableFile, containerPath);
        logger.info("Putting file {} into container path {}", (Object)file.getAbsolutePath(), (Object)containerPath);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SELF disableExtension(@NotNull String extensionName, @NotNull String extensionDirectory, @NotNull Duration timeout) {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) stopped successfully(.*)";
        try {
            String containerPath = "/opt/hivemq/extensions" + PathUtil.preparePath(extensionDirectory) + "DISABLED";
            CountDownLatch latch = new CountDownLatch(1);
            this.containerOutputLatches.put(regEX, latch);
            this.execInContainer(new String[]{"touch", containerPath});
            logger.info("Putting DISABLED file into container path {}", (Object)containerPath);
            boolean await = latch.await(timeout.getSeconds(), TimeUnit.SECONDS);
            if (!await) {
                logger.warn("Extension disabling timed out after {} seconds. Maybe you are using a HiveMQ Community Edition image, which does not support disabling of extensions", (Object)timeout.getSeconds());
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.containerOutputLatches.remove(regEX);
        }
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF disableExtension(@NotNull String extensionName, @NotNull String extensionDirectory) {
        return this.disableExtension(extensionName, extensionDirectory, Duration.ofSeconds(60L));
    }

    @NotNull
    public SELF disableExtension(@NotNull HiveMQExtension hiveMQExtension, @NotNull Duration timeout) {
        return this.disableExtension(hiveMQExtension.getName(), hiveMQExtension.getId(), timeout);
    }

    @NotNull
    public SELF disableExtension(@NotNull HiveMQExtension hiveMQExtension) {
        return this.disableExtension(hiveMQExtension, Duration.ofSeconds(60L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SELF enableExtension(@NotNull String extensionName, @NotNull String extensionDirectory, @NotNull Duration timeout) {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) started successfully(.*)";
        try {
            String containerPath = "/opt/hivemq/extensions" + PathUtil.preparePath(extensionDirectory) + "DISABLED";
            CountDownLatch latch = new CountDownLatch(1);
            this.containerOutputLatches.put(regEX, latch);
            this.execInContainer(new String[]{"rm", "-rf", containerPath});
            logger.info("Removing DISABLED file in container path {}", (Object)containerPath);
            boolean await = latch.await(timeout.getSeconds(), TimeUnit.SECONDS);
            if (!await) {
                logger.warn("Extension enabling timed out after {} seconds. Maybe you are using a HiveMQ Community Edition image, which does not support disabling of extensions", (Object)timeout.getSeconds());
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.containerOutputLatches.remove(regEX);
        }
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF enableExtension(@NotNull String extensionName, @NotNull String extensionDirectory) {
        return this.enableExtension(extensionName, extensionDirectory, Duration.ofSeconds(60L));
    }

    @NotNull
    public SELF enableExtension(@NotNull HiveMQExtension hiveMQExtension, @NotNull Duration timeout) {
        return this.enableExtension(hiveMQExtension.getName(), hiveMQExtension.getId(), timeout);
    }

    @NotNull
    public SELF enableExtension(@NotNull HiveMQExtension hiveMQExtension) {
        return this.enableExtension(hiveMQExtension, Duration.ofSeconds(60L));
    }

    @NotNull
    public SELF silent(boolean silent) {
        this.silent = silent;
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withControlCenter() {
        return this.withControlCenter(8080);
    }

    @NotNull
    public SELF withControlCenter(int controlCenterPort) {
        this.addExposedPorts(new int[]{8080});
        this.addFixedExposedPort(controlCenterPort, 8080);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    public int getMqttPort() {
        return this.getMappedPort(1883);
    }

    protected void signExtension(@NotNull String extensionId, @NotNull File jar) {
    }
}

