/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.testcontainer.core;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.io.File;
import java.util.Properties;
import java.util.function.Supplier;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.EmbeddedMaven;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.ConfigurationDistributionStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.pom.equipped.PomEquippedEmbeddedMaven;
import org.testcontainers.shaded.com.google.common.io.Files;

public class MavenHiveMQExtensionSupplier
implements Supplier<File> {
    @NotNull
    private final String pomFile;
    private boolean quiet = false;
    @NotNull
    private final Properties properties = new Properties();

    @NotNull
    public static MavenHiveMQExtensionSupplier direct() {
        return new MavenHiveMQExtensionSupplier("pom.xml");
    }

    public MavenHiveMQExtensionSupplier(@NotNull String pomFile) {
        this.pomFile = pomFile;
    }

    @Override
    @NotNull
    public File get() {
        PomEquippedEmbeddedMaven embeddedMaven = EmbeddedMaven.forProject((String)this.pomFile);
        ((ConfigurationDistributionStage)((ConfigurationDistributionStage)embeddedMaven.setGoals(new String[]{"package"})).setQuiet(this.quiet)).setBatchMode(true);
        embeddedMaven.setProperties(this.properties);
        BuiltProject aPackage = embeddedMaven.build();
        File targetDirectory = aPackage.getTargetDirectory();
        String version = aPackage.getModel().getVersion();
        String artifactId = aPackage.getModel().getArtifactId();
        ZipFile zipFile = new ZipFile(new File(targetDirectory, artifactId + "-" + version + "-distribution.zip"));
        File tempDir = Files.createTempDir();
        try {
            zipFile.extractAll(tempDir.getAbsolutePath());
        }
        catch (ZipException e) {
            throw new RuntimeException(e);
        }
        return new File(tempDir, artifactId);
    }

    @NotNull
    public MavenHiveMQExtensionSupplier quiet() {
        this.quiet = true;
        return this;
    }

    @NotNull
    public MavenHiveMQExtensionSupplier addProperty(@NotNull String key, @NotNull String value) {
        this.properties.put(key, value);
        return this;
    }
}

