/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.testcontainer.core;

import com.github.dockerjava.api.DockerClient;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.WaitingConsumer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.utility.LogUtils;

class MultiLogMessageWaitStrategy
extends AbstractWaitStrategy {
    @NotNull
    private final ConcurrentHashMap<String, Boolean> regexes = new ConcurrentHashMap();

    MultiLogMessageWaitStrategy() {
    }

    protected void waitUntilReady() {
        WaitingConsumer waitingConsumer = new WaitingConsumer();
        LogUtils.followOutput((DockerClient)DockerClientFactory.instance().client(), (String)this.waitStrategyTarget.getContainerId(), (Consumer)waitingConsumer);
        Predicate<OutputFrame> waitPredicate = outputFrame -> {
            if (this.regexes.isEmpty()) {
                return true;
            }
            this.regexes.entrySet().forEach(stringBooleanEntry -> {
                boolean matched = outputFrame.getUtf8String().matches("(?s)" + (String)stringBooleanEntry.getKey());
                if (matched) {
                    stringBooleanEntry.setValue(true);
                }
            });
            return this.regexes.values().stream().reduce(Boolean::logicalAnd).orElse(true);
        };
        try {
            waitingConsumer.waitUntil(waitPredicate, this.startupTimeout.getSeconds(), TimeUnit.SECONDS, 1);
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for log output matching '" + this.regexes + "'");
        }
    }

    @NotNull
    public MultiLogMessageWaitStrategy withRegEx(@NotNull String regEx) {
        this.regexes.put(regEx, false);
        return this;
    }
}

