/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.testcontainer.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.utility.MountableFile;

public class GradleHiveMQExtensionSupplier
implements Supplier<MountableFile> {
    @NotNull
    private static final Pattern ROOT_PROJECT_PATTERN = Pattern.compile(".*'(.*)'");
    @NotNull
    private static final String PROPERTY_REGEX = "(.*): (.*)";
    @NotNull
    private static final String BUILD_STARTED = "=================================================================\n===   Embedded Gradle build started: %s   ===\n=================================================================\n";
    @NotNull
    private static final String BUILD_STOPPED = "=================================================================\n===   Embedded Gradle build stopped: %s   ===\n=================================================================";
    @NotNull
    private static final String TASK = "hivemqExtensionZip";
    @NotNull
    private final File gradleProjectDirectory;
    private boolean quiet = false;

    public GradleHiveMQExtensionSupplier(@NotNull File gradleProjectDirectory) {
        if (!gradleProjectDirectory.exists()) {
            throw new IllegalStateException(gradleProjectDirectory + " does not exist.");
        }
        if (!gradleProjectDirectory.canRead()) {
            throw new IllegalStateException(gradleProjectDirectory + " is not readable.");
        }
        this.gradleProjectDirectory = gradleProjectDirectory;
    }

    @Override
    @NotNull
    public MountableFile get() {
        System.out.printf("=================================================================\n===   Embedded Gradle build started: %s   ===\n=================================================================\n%n", this.gradleProjectDirectory);
        try {
            Process extensionZipProcess;
            int extensionZipExitCode;
            ProcessBuilder extensionZipProcessBuilder = new ProcessBuilder(new String[0]);
            extensionZipProcessBuilder.directory(this.gradleProjectDirectory);
            extensionZipProcessBuilder.command(this.getCommandForOs(this.gradleProjectDirectory), TASK);
            extensionZipProcessBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            if (!this.quiet) {
                extensionZipProcessBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
            if ((extensionZipExitCode = (extensionZipProcess = extensionZipProcessBuilder.start()).waitFor()) != 0) {
                throw new IllegalStateException("Gradle build exited with code " + extensionZipExitCode);
            }
            ProcessBuilder propertiesProcessBuilder = new ProcessBuilder(new String[0]);
            propertiesProcessBuilder.directory(this.gradleProjectDirectory);
            propertiesProcessBuilder.command(this.getCommandForOs(this.gradleProjectDirectory), "properties", "-q");
            propertiesProcessBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process propertiesProcess = propertiesProcessBuilder.start();
            int propertiesExitCode = propertiesProcess.waitFor();
            if (propertiesExitCode != 0) {
                throw new IllegalStateException("Gradle build exited with code " + propertiesExitCode);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(propertiesProcess.getInputStream()));
            Map<String, String> gradleProperties = br.lines().filter(s -> s.matches(PROPERTY_REGEX)).map(s -> {
                String[] splits = s.split(": ");
                return new AbstractMap.SimpleEntry<String, String>(splits[0], splits[1]);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            System.out.printf("=================================================================\n===   Embedded Gradle build stopped: %s   ===\n=================================================================%n", this.gradleProjectDirectory);
            String projectVersion = gradleProperties.get("version");
            String rootProject = gradleProperties.get("rootProject");
            Matcher matcher = ROOT_PROJECT_PATTERN.matcher(rootProject);
            boolean b = matcher.find();
            String projectName = matcher.group(1);
            ZipFile zipFile = new ZipFile(new File(this.gradleProjectDirectory, "build/hivemq-extension/" + projectName + "-" + projectVersion + ".zip"));
            Path tempDirectory = Files.createTempDirectory("", new FileAttribute[0]);
            zipFile.extractAll(tempDirectory.toString());
            return MountableFile.forHostPath((Path)tempDirectory.resolve(projectName));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while building the HiveMQ extension with gradle.", e);
        }
    }

    @NotNull
    private String getCommandForOs(@NotNull File gradleProjectFile) {
        String gradleWrapperBat;
        File gradleWrapperBatFile;
        if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_LINUX) {
            String gradleWrapper = gradleProjectFile + "/gradlew";
            File gradleWrapperBashFile = new File(gradleWrapper);
            if (gradleWrapperBashFile.exists()) {
                if (!gradleWrapperBashFile.canExecute()) {
                    throw new IllegalStateException("Gradle Wrapper " + gradleWrapperBashFile.getAbsolutePath() + " can not be executed.");
                }
                return gradleWrapperBashFile.getAbsolutePath();
            }
        } else if (SystemUtils.IS_OS_WINDOWS && (gradleWrapperBatFile = new File(gradleWrapperBat = gradleProjectFile + "/gradlew.bat")).exists()) {
            if (!gradleWrapperBatFile.canExecute()) {
                throw new IllegalStateException("Gradle Wrapper " + gradleWrapperBatFile.getAbsolutePath() + " can not be executed.");
            }
            return gradleWrapperBatFile.getAbsolutePath();
        }
        throw new IllegalStateException("Unknown OS Version");
    }

    @NotNull
    public GradleHiveMQExtensionSupplier quiet() {
        this.quiet = true;
        return this;
    }
}

