/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.testcontainer.core;

import com.hivemq.extension.sdk.api.ExtensionMain;
import com.hivemq.testcontainer.core.HiveMQExtension;
import com.hivemq.testcontainer.core.MultiLogMessageWaitStrategy;
import com.hivemq.testcontainer.core.PathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.NotFoundException;
import org.apache.commons.io.FileUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class HiveMQTestContainerCore<SELF extends HiveMQTestContainerCore<SELF>>
extends GenericContainer<SELF> {
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(HiveMQTestContainerCore.class);
    @NotNull
    private static final String validPluginXML = "<hivemq-extension>   <id>%s</id>   <name>%s</name>   <version>%s</version>   <priority>%s</priority>   <start-priority>%s</start-priority></hivemq-extension>";
    @NotNull
    private static final String DEFAULT_HIVEMQ_IMAGE = "hivemq/hivemq-ce";
    @NotNull
    private static final String DEFAULT_HIVEMQ_TAG = "latest";
    public static final int DEBUGGING_PORT = 9000;
    public static final int MQTT_PORT = 1883;
    public static final int CONTROL_CENTER_PORT = 8080;
    private static final int MODE = 511;
    @NotNull
    private static final Pattern EXTENSION_ID_PATTERN = Pattern.compile("<id>(.+?)</id>");
    @NotNull
    private final ConcurrentHashMap<String, CountDownLatch> containerOutputLatches = new ConcurrentHashMap();
    private volatile boolean silent = false;
    private volatile boolean controlCenterEnabled = false;
    @NotNull
    private final MultiLogMessageWaitStrategy waitStrategy = new MultiLogMessageWaitStrategy();

    public HiveMQTestContainerCore() {
        this(DockerImageName.parse((String)DEFAULT_HIVEMQ_IMAGE).withTag(DEFAULT_HIVEMQ_TAG));
    }

    public HiveMQTestContainerCore(@NotNull DockerImageName dockerImageName) {
        super(dockerImageName);
        this.addExposedPort(1883);
        this.waitStrategy.withRegEx("(.*)Started HiveMQ in(.*)");
        this.waitingFor((WaitStrategy)this.waitStrategy);
        this.withLogConsumer(outputFrame -> {
            String utf8String = outputFrame.getUtf8String();
            if (utf8String.startsWith("Listening for transport dt_socket at address:")) {
                System.out.println("Listening for transport dt_socket at address: " + this.getMappedPort(9000));
            } else if (!this.silent) {
                System.out.print(utf8String);
            }
        });
        this.withLogConsumer(outputFrame -> {
            if (!this.containerOutputLatches.isEmpty()) {
                this.containerOutputLatches.forEach((regEx, latch) -> {
                    if (outputFrame.getUtf8String().matches("(?s)" + regEx)) {
                        logger.debug("Container Output '{}' matched RegEx '{}'", (Object)outputFrame.getUtf8String(), regEx);
                        latch.countDown();
                    } else {
                        logger.debug("Container Output '{}' did not match RegEx '{}'", (Object)outputFrame.getUtf8String(), regEx);
                    }
                });
            }
        });
    }

    public void start() {
        super.start();
        if (this.controlCenterEnabled) {
            logger.info("The HiveMQ Control Center is reachable under: http://localhost:{}", (Object)this.getMappedPort(8080));
        }
    }

    @NotNull
    public SELF waitForExtension(@NotNull String extensionName) {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) started successfully(.*)";
        this.waitStrategy.withRegEx(regEX);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF waitForExtension(@NotNull HiveMQExtension extension) {
        return this.waitForExtension(extension.getName());
    }

    @NotNull
    public SELF withDebugging() {
        this.addExposedPorts(new int[]{9000});
        this.withEnv("JAVA_OPTS", "-agentlib:jdwp=transport=dt_socket,address=0.0.0.0:9000,server=y,suspend=y");
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withLogLevel(@NotNull Level level) {
        this.withEnv("HIVEMQ_LOG_LEVEL", level.name());
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withExtension(@NotNull HiveMQExtension hiveMQExtension) {
        try {
            File extension = this.createExtension(hiveMQExtension);
            MountableFile mountableExtension = MountableFile.forHostPath((String)extension.getPath(), (Integer)511);
            this.withCopyFileToContainer(mountableExtension, "/opt/hivemq/extensions/" + hiveMQExtension.getId());
        }
        catch (Exception e) {
            throw new ContainerLaunchException(e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
        }
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withExtension(@NotNull MountableFile mountableExtension) {
        File extensionDir = new File(mountableExtension.getResolvedPath());
        if (!extensionDir.exists()) {
            throw new ContainerLaunchException("Extension '" + mountableExtension.getFilesystemPath() + "' could not be mounted. It does not exist.");
        }
        if (!extensionDir.isDirectory()) {
            throw new ContainerLaunchException("Extension '" + mountableExtension.getFilesystemPath() + "' could not be mounted. It is not a directory.");
        }
        try {
            String extensionDirName = this.getExtensionDirectoryName(extensionDir);
            String containerPath = "/opt/hivemq/extensions/" + extensionDirName;
            this.withCopyFileToContainer(this.cloneWithFileMode(mountableExtension, 511), containerPath);
            logger.info("Putting extension '{}' into '{}'", (Object)extensionDirName, (Object)containerPath);
        }
        catch (Exception e) {
            throw new ContainerLaunchException(e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
        }
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    private String getExtensionDirectoryName(@NotNull File extensionDirectory) throws IOException {
        File file = new File(extensionDirectory, "hivemq-extension.xml");
        String xml = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Matcher matcher = EXTENSION_ID_PATTERN.matcher(xml);
        if (!matcher.find()) {
            throw new IllegalStateException("Could not parse extension id from '" + file.getAbsolutePath() + "'");
        }
        return matcher.group(1);
    }

    @NotNull
    private File createExtension(@NotNull HiveMQExtension hiveMQExtension) throws Exception {
        File disabled;
        boolean newFile;
        File tempDir = Files.createTempDirectory("", new FileAttribute[0]).toFile();
        File extensionDir = new File(tempDir, hiveMQExtension.getId());
        FileUtils.writeStringToFile((File)new File(extensionDir, "hivemq-extension.xml"), (String)String.format(validPluginXML, hiveMQExtension.getId(), hiveMQExtension.getName(), hiveMQExtension.getVersion(), hiveMQExtension.getPriority(), hiveMQExtension.getStartPriority()), (Charset)Charset.defaultCharset());
        if (hiveMQExtension.isDisabledOnStartup() && !(newFile = (disabled = new File(extensionDir, "DISABLED")).createNewFile())) {
            throw new ContainerLaunchException("Could not create DISABLED file '" + disabled.getAbsolutePath() + "' on host machine.");
        }
        JavaArchive javaArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsServiceProviderAndClasses(ExtensionMain.class, new Class[]{hiveMQExtension.getMainClass()});
        this.putSubclassesIntoJar(hiveMQExtension.getId(), hiveMQExtension.getMainClass(), javaArchive);
        for (Class additionalClass : hiveMQExtension.getAdditionalClasses()) {
            javaArchive.addClass(additionalClass);
            this.putSubclassesIntoJar(hiveMQExtension.getId(), additionalClass, javaArchive);
        }
        ((ZipExporter)javaArchive.as(ZipExporter.class)).exportTo(new File(extensionDir, "extension.jar"));
        return extensionDir;
    }

    private void putSubclassesIntoJar(@NotNull String extensionId, @Nullable Class<?> clazz, @NotNull JavaArchive javaArchive) throws NotFoundException {
        if (clazz != null) {
            Set subClassNames = ClassPool.getDefault().get(clazz.getName()).getClassFile().getConstPool().getClassNames();
            for (String subClassName : subClassNames) {
                String className = subClassName.replaceAll("/", ".");
                if (!className.startsWith("[L")) {
                    logger.debug("Trying to package subclass '{}' into extension '{}'.", (Object)className, (Object)extensionId);
                    javaArchive.addClass(className);
                    continue;
                }
                logger.debug("Class '{}' will be ignored.", (Object)className);
            }
        }
    }

    @NotNull
    public SELF withoutPrepackagedExtensions(String ... extensionIds) {
        String dockerImageName = this.getDockerImageName();
        this.setImage((Future)new ImageFromDockerfile(dockerImageName + "-custom").withDockerfileFromBuilder(builder -> {
            builder.from(dockerImageName);
            for (String extensionId : extensionIds) {
                builder.run(new String[]{"rm", "-rf", "/opt/hivemq/extensions/" + extensionId});
            }
        }));
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withoutPrepackagedExtensions() {
        String dockerImageName = this.getDockerImageName();
        this.setImage((Future)new ImageFromDockerfile(dockerImageName + "-custom").withDockerfileFromBuilder(builder -> ((DockerfileBuilder)builder.from(dockerImageName)).run(new String[]{"rm", "-rf", "/opt/hivemq/extensions/"})));
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withLicense(@NotNull MountableFile mountableLicense) {
        File licenseFile = new File(mountableLicense.getResolvedPath());
        if (!licenseFile.exists()) {
            throw new ContainerLaunchException("License file '" + mountableLicense.getFilesystemPath() + "' does not exist.");
        }
        if (!licenseFile.getName().endsWith(".lic") && !licenseFile.getName().endsWith(".elic")) {
            throw new ContainerLaunchException("License file '" + mountableLicense.getFilesystemPath() + "' does not end wit '.lic' or '.elic'.");
        }
        String containerPath = "/opt/hivemq/license/" + licenseFile.getName();
        this.withCopyFileToContainer(this.cloneWithFileMode(mountableLicense, 511), containerPath);
        logger.info("Putting license '{}' into '{}'.", (Object)licenseFile.getAbsolutePath(), (Object)containerPath);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withHiveMQConfig(@NotNull MountableFile mountableConfig) {
        File config = new File(mountableConfig.getResolvedPath());
        if (!config.exists()) {
            throw new ContainerLaunchException("HiveMQ config file '" + mountableConfig.getFilesystemPath() + "' does not exist.");
        }
        String containerPath = "/opt/hivemq/conf/config.xml";
        this.withCopyFileToContainer(this.cloneWithFileMode(mountableConfig, 511), "/opt/hivemq/conf/config.xml");
        logger.info("Putting '{}' into '{}'.", (Object)config.getAbsolutePath(), (Object)"/opt/hivemq/conf/config.xml");
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withFileInExtensionHomeFolder(@NotNull MountableFile file, @NotNull String extensionId) {
        return this.withFileInExtensionHomeFolder(file, extensionId, "");
    }

    @NotNull
    public SELF withFileInExtensionHomeFolder(@NotNull MountableFile file, @NotNull String extensionId, @NotNull String pathInExtensionHome) {
        return this.withFileInHomeFolder(file, "/extensions/" + extensionId + PathUtil.preparePath(pathInExtensionHome));
    }

    @NotNull
    public SELF withFileInHomeFolder(@NotNull MountableFile file) {
        return this.withFileInHomeFolder(file, "");
    }

    @NotNull
    public SELF withFileInHomeFolder(@NotNull MountableFile mountableFile, @NotNull String pathInHomeFolder) {
        File file = new File(mountableFile.getResolvedPath());
        if (!file.exists()) {
            throw new ContainerLaunchException("File '" + mountableFile.getFilesystemPath() + "\u2018 does not exist.");
        }
        String containerPath = "/opt/hivemq" + PathUtil.preparePath(pathInHomeFolder) + file.getName();
        this.withCopyFileToContainer(this.cloneWithFileMode(mountableFile, 511), containerPath);
        logger.info("Putting file '{}' into container path '{}'.", (Object)file.getAbsolutePath(), (Object)containerPath);
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    public void disableExtension(@NotNull String extensionName, @NotNull String extensionDirectory, @NotNull Duration timeout) throws TimeoutException {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) stopped successfully(.*)";
        try {
            String containerPath = "/opt/hivemq/extensions" + PathUtil.preparePath(extensionDirectory) + "DISABLED";
            CountDownLatch latch = new CountDownLatch(1);
            this.containerOutputLatches.put(regEX, latch);
            this.execInContainer(new String[]{"touch", containerPath});
            logger.info("Putting DISABLED file into container path '{}'", (Object)containerPath);
            boolean await = latch.await(timeout.getSeconds(), TimeUnit.SECONDS);
            if (!await) {
                throw new TimeoutException("Extension disabling timed out after '" + timeout.getSeconds() + "' seconds. Maybe you are using a HiveMQ Community Edition image, which does not support disabling of extensions");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.containerOutputLatches.remove(regEX);
        }
    }

    public void disableExtension(@NotNull String extensionName, @NotNull String extensionDirectory) throws TimeoutException {
        this.disableExtension(extensionName, extensionDirectory, Duration.ofSeconds(60L));
    }

    public void disableExtension(@NotNull HiveMQExtension hiveMQExtension, @NotNull Duration timeout) throws TimeoutException {
        this.disableExtension(hiveMQExtension.getName(), hiveMQExtension.getId(), timeout);
    }

    public void disableExtension(@NotNull HiveMQExtension hiveMQExtension) throws TimeoutException {
        this.disableExtension(hiveMQExtension, Duration.ofSeconds(60L));
    }

    public void enableExtension(@NotNull String extensionName, @NotNull String extensionDirectory, @NotNull Duration timeout) throws TimeoutException {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) started successfully(.*)";
        try {
            String containerPath = "/opt/hivemq/extensions" + PathUtil.preparePath(extensionDirectory) + "DISABLED";
            CountDownLatch latch = new CountDownLatch(1);
            this.containerOutputLatches.put(regEX, latch);
            this.execInContainer(new String[]{"rm", "-rf", containerPath});
            logger.info("Removing DISABLED file in container path '{}'", (Object)containerPath);
            boolean await = latch.await(timeout.getSeconds(), TimeUnit.SECONDS);
            if (!await) {
                throw new TimeoutException("Extension enabling timed out after '" + timeout.getSeconds() + "' seconds. Maybe you are using a HiveMQ Community Edition image, which does not support disabling of extensions");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.containerOutputLatches.remove(regEX);
        }
    }

    public void enableExtension(@NotNull String extensionName, @NotNull String extensionDirectory) throws TimeoutException {
        this.enableExtension(extensionName, extensionDirectory, Duration.ofSeconds(60L));
    }

    public void enableExtension(@NotNull HiveMQExtension hiveMQExtension, @NotNull Duration timeout) throws TimeoutException {
        this.enableExtension(hiveMQExtension.getName(), hiveMQExtension.getId(), timeout);
    }

    public void enableExtension(@NotNull HiveMQExtension hiveMQExtension) throws TimeoutException {
        this.enableExtension(hiveMQExtension, Duration.ofSeconds(60L));
    }

    @NotNull
    public SELF silent(boolean silent) {
        this.silent = silent;
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    @NotNull
    public SELF withControlCenter() {
        this.addExposedPorts(new int[]{8080});
        this.controlCenterEnabled = true;
        return (SELF)((Object)((HiveMQTestContainerCore)this.self()));
    }

    public int getMqttPort() {
        return this.getMappedPort(1883);
    }

    public void stop() {
        this.waitStrategy.reset();
        super.stop();
    }

    @NotNull
    private MountableFile cloneWithFileMode(@NotNull MountableFile mountableFile, int mode) {
        return MountableFile.forHostPath((String)mountableFile.getResolvedPath(), (Integer)mode);
    }
}

