/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.pact.gen.domain.client.feign;

import com.google.common.collect.Lists;
import com.hltech.pact.gen.domain.client.ClientMethodRepresentationExtractor;
import com.hltech.pact.gen.domain.client.annotation.handlers.AnnotatedMethodHandler;
import com.hltech.pact.gen.domain.client.feign.InteractionInfo;
import com.hltech.pact.gen.domain.client.model.ClientMethodRepresentation;
import com.hltech.pact.gen.domain.client.model.RequestRepresentation;
import com.hltech.pact.gen.domain.client.model.ResponseRepresentation;
import com.hltech.pact.gen.domain.client.util.RawHeadersParser;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class FeignMethodRepresentationExtractor
implements ClientMethodRepresentationExtractor {
    private final Collection<AnnotatedMethodHandler> annotatedMethodHandlers;

    public FeignMethodRepresentationExtractor(Collection<AnnotatedMethodHandler> annotatedMethodHandlers) {
        this.annotatedMethodHandlers = annotatedMethodHandlers;
    }

    @Override
    public ClientMethodRepresentation extractClientMethodRepresentation(Method method) {
        return ClientMethodRepresentation.builder().requestRepresentation(this.extractRequestProperties(method)).responseRepresentationList(this.extractResponseProperties(method)).build();
    }

    private RequestRepresentation extractRequestProperties(Method method) {
        return this.annotatedMethodHandlers.stream().filter(annotationHandler -> annotationHandler.isSupported(method)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown HTTP method")).handleRequest(method);
    }

    private List<ResponseRepresentation> extractResponseProperties(Method method) {
        String[] responseHeaders = this.annotatedMethodHandlers.stream().filter(annotationHandler -> annotationHandler.isSupported(method)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown HTTP method")).getResponseMediaHeaders(method);
        ArrayList results = Arrays.stream((InteractionInfo[])method.getDeclaredAnnotationsByType(InteractionInfo.class)).map(annotation -> ResponseRepresentation.from(annotation.responseStatus(), RawHeadersParser.parseAll((String[])ArrayUtils.addAll((Object[])annotation.responseHeaders(), (Object[])responseHeaders)), method, annotation.description(), annotation.emptyBodyExpected())).collect(Collectors.toList());
        return !results.isEmpty() ? results : Lists.newArrayList((Object[])new ResponseRepresentation[]{ResponseRepresentation.getDefaultForMethod(method, responseHeaders)});
    }
}

