/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.pact.gen.domain.client.jaxrs;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Path;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

public class JaxRsClientsFinder {
    public Set<Class<?>> findJaxRsClients(String packageRoot) {
        HashSet jaxRsClients = new HashSet();
        jaxRsClients.addAll(this.classAnnotatedClients(packageRoot));
        jaxRsClients.addAll(this.methodAnnotatedClients(packageRoot));
        return jaxRsClients;
    }

    private Set<Class<?>> classAnnotatedClients(String packageRoot) {
        return new Reflections(packageRoot, new Scanner[0]).getTypesAnnotatedWith(Path.class);
    }

    private Set<Class<?>> methodAnnotatedClients(String packageRoot) {
        return new Reflections(packageRoot, new Scanner[]{new MethodAnnotationsScanner()}).getMethodsAnnotatedWith(Path.class).stream().map(Method::getDeclaringClass).collect(Collectors.toSet());
    }
}

