/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.pact.gen.domain.client.model;

import com.hltech.pact.gen.domain.client.model.Body;
import com.hltech.pact.gen.domain.client.model.Param;
import com.hltech.pact.gen.domain.client.util.RawHeadersParser;
import com.hltech.pact.gen.domain.client.util.TypeExtractor;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;

public class ResponseRepresentation {
    private final HttpStatus status;
    private final List<Param> headers;
    private final Body body;
    private final String description;
    private final boolean emptyBodyExpected;

    public static ResponseRepresentation getDefaultForMethod(Method method, String[] responseHeaders) {
        return ResponseRepresentation.from(HttpStatus.OK, RawHeadersParser.parseAll(responseHeaders), method, "", false);
    }

    public static ResponseRepresentation from(HttpStatus status, List<Param> headers, Method method, String description, boolean isEmptyBodyExpected) {
        return ResponseRepresentation.builder().status(status).headers(headers).body(Body.builder().type(method.getReturnType()).genericArgumentTypes(TypeExtractor.extractParameterTypesFromType(method.getGenericReturnType())).build()).description(description).emptyBodyExpected(isEmptyBodyExpected).build();
    }

    @Generated
    ResponseRepresentation(HttpStatus status, List<Param> headers, Body body, String description, boolean emptyBodyExpected) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.description = description;
        this.emptyBodyExpected = emptyBodyExpected;
    }

    @Generated
    public static ResponseRepresentationBuilder builder() {
        return new ResponseRepresentationBuilder();
    }

    @Generated
    public HttpStatus getStatus() {
        return this.status;
    }

    @Generated
    public List<Param> getHeaders() {
        return this.headers;
    }

    @Generated
    public Body getBody() {
        return this.body;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isEmptyBodyExpected() {
        return this.emptyBodyExpected;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseRepresentation)) {
            return false;
        }
        ResponseRepresentation other = (ResponseRepresentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpStatus this$status = this.getStatus();
        HttpStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<Param> this$headers = this.getHeaders();
        List<Param> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        return this.isEmptyBodyExpected() == other.isEmptyBodyExpected();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResponseRepresentation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<Param> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + (this.isEmptyBodyExpected() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "ResponseRepresentation(status=" + this.getStatus() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", description=" + this.getDescription() + ", emptyBodyExpected=" + this.isEmptyBodyExpected() + ")";
    }

    @Generated
    public static class ResponseRepresentationBuilder {
        @Generated
        private HttpStatus status;
        @Generated
        private List<Param> headers;
        @Generated
        private Body body;
        @Generated
        private String description;
        @Generated
        private boolean emptyBodyExpected;

        @Generated
        ResponseRepresentationBuilder() {
        }

        @Generated
        public ResponseRepresentationBuilder status(HttpStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public ResponseRepresentationBuilder headers(List<Param> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public ResponseRepresentationBuilder body(Body body) {
            this.body = body;
            return this;
        }

        @Generated
        public ResponseRepresentationBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ResponseRepresentationBuilder emptyBodyExpected(boolean emptyBodyExpected) {
            this.emptyBodyExpected = emptyBodyExpected;
            return this;
        }

        @Generated
        public ResponseRepresentation build() {
            return new ResponseRepresentation(this.status, this.headers, this.body, this.description, this.emptyBodyExpected);
        }

        @Generated
        public String toString() {
            return "ResponseRepresentation.ResponseRepresentationBuilder(status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + ", description=" + this.description + ", emptyBodyExpected=" + this.emptyBodyExpected + ")";
        }
    }
}

