/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.pact.gen.domain.client.util;

import com.hltech.pact.gen.domain.client.model.Param;
import com.hltech.pact.gen.domain.client.util.TypeExtractor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestHeader;

public final class RequestHeaderParamsExtractor {
    private RequestHeaderParamsExtractor() {
    }

    public static List<Param> extractAll(Method feignClientMethod) {
        return Arrays.stream(feignClientMethod.getParameters()).filter(param -> param.getAnnotation(RequestHeader.class) != null).filter(param -> param.getType() != Map.class && param.getType() != MultiValueMap.class && param.getType() != HttpHeaders.class).map(RequestHeaderParamsExtractor::extract).collect(Collectors.toList());
    }

    private static Param extract(Parameter param) {
        Param.ParamBuilder builder = Param.builder();
        RequestHeaderParamsExtractor.extractHeaderDefaultValue(param).ifPresent(builder::defaultValue);
        List<Class<?>> paramTypes = TypeExtractor.extractParameterTypesFromType(param.getParameterizedType());
        return builder.name(RequestHeaderParamsExtractor.extractHeaderName(param)).type(param.getType()).genericArgumentType(paramTypes.isEmpty() ? null : paramTypes.get(0)).build();
    }

    private static Optional<Object> extractHeaderDefaultValue(Parameter param) {
        RequestHeader annotation = param.getAnnotation(RequestHeader.class);
        if (annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") || annotation.defaultValue().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(annotation.defaultValue());
    }

    private static String extractHeaderName(Parameter param) {
        RequestHeader annotation = param.getAnnotation(RequestHeader.class);
        if (!annotation.name().isEmpty()) {
            return annotation.name();
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return param.getName();
    }
}

