/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.pact.gen.domain.pact;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hltech.pact.gen.PactGenerationException;
import com.hltech.pact.gen.domain.client.model.Body;
import java.lang.reflect.Type;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.PodamFactory;

final class BodySerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BodySerializer.class);

    private BodySerializer() {
    }

    static JsonNode serializeBody(Body body, ObjectMapper objectMapper, PodamFactory podamFactory) {
        String serializedBody = null;
        JsonNode bodyJsonNode = null;
        try {
            if (body.getType() != null && !body.getType().equals(Void.TYPE)) {
                serializedBody = objectMapper.writeValueAsString(BodySerializer.populateRequestObject(body, podamFactory));
                bodyJsonNode = objectMapper.readTree(serializedBody);
            }
        }
        catch (JsonProcessingException ex) {
            log.error("Unable to write {} to json. Original error message '{}'", (Object)body, (Object)ex.getMessage());
            throw new PactGenerationException("Unable to serialize body", ex);
        }
        return bodyJsonNode;
    }

    private static Object populateRequestObject(Body body, PodamFactory podamFactory) {
        Object manufacturedPojo;
        Type[] types = body.getGenericArgumentTypes().toArray(new Class[0]);
        Object object = manufacturedPojo = Optional.class.equals(body.getType()) ? podamFactory.manufacturePojo(types[0], new Type[0]) : podamFactory.manufacturePojo(body.getType(), types);
        if (manufacturedPojo == null) {
            throw new PactGenerationException("Podam manufacturing failed");
        }
        return manufacturedPojo;
    }
}

