/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.pact.gen.domain.pact;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hltech.pact.gen.PactGenerationException;
import com.hltech.pact.gen.domain.pact.model.Pact;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PactJsonGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PactJsonGenerator.class);
    private ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public void writePactFiles(File destinationDir, Collection<Pact> pacts) {
        pacts.forEach(pact -> this.writePactFile(destinationDir, (Pact)pact));
    }

    private void writePactFile(File destinationDir, Pact pact) {
        if (destinationDir != null && !destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        String pactFileName = pact.getConsumer().getName() + "-" + pact.getProvider().getName() + ".json";
        try {
            this.objectMapper.writeValue(new File(destinationDir, pactFileName), (Object)pact);
        }
        catch (IOException ex) {
            log.error("Unable to write {} to json file", (Object)pact);
            throw new PactGenerationException("Unable to write pact to json file", ex);
        }
    }
}

