/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.pact.gen.domain.pact;

import com.hltech.pact.gen.domain.client.model.Body;
import com.hltech.pact.gen.domain.client.model.ClientMethodRepresentation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

final class PojoExtractor {
    private PojoExtractor() {
    }

    static Set<Class<?>> extractPojoTypes(ClientMethodRepresentation methodRepresentation) {
        HashSet pojoClasses = new HashSet();
        pojoClasses.addAll(PojoExtractor.extractPojosFromRequestProperties(methodRepresentation));
        pojoClasses.addAll(PojoExtractor.extractPojosFromResponseProperties(methodRepresentation));
        return pojoClasses.stream().filter(clazz -> clazz != Void.TYPE).collect(Collectors.toSet());
    }

    private static Set<Class<?>> extractPojosFromRequestProperties(ClientMethodRepresentation methodRepresentation) {
        return new HashSet(PojoExtractor.extractTypesFromBody(methodRepresentation.getRequestRepresentation().getBody()));
    }

    private static Set<Class<?>> extractPojosFromResponseProperties(ClientMethodRepresentation methodRepresentation) {
        HashSet pojoClasses = new HashSet();
        methodRepresentation.getResponseRepresentationList().forEach(responseProperties -> pojoClasses.addAll(PojoExtractor.extractTypesFromBody(responseProperties.getBody())));
        return pojoClasses;
    }

    private static Set<Class<?>> extractTypesFromBody(Body body) {
        HashSet typesFromBody = new HashSet();
        if (body.getType() != null) {
            typesFromBody.add(body.getType());
        }
        if (!CollectionUtils.isEmpty(body.getGenericArgumentTypes())) {
            typesFromBody.addAll(body.getGenericArgumentTypes());
        }
        return PojoExtractor.extractNestedTypes(typesFromBody);
    }

    private static Set<Class<?>> extractNestedTypes(Collection<Class<?>> classes) {
        return classes.stream().map(PojoExtractor::extractNestedTypes).flatMap(Collection::stream).map(clazz -> PojoExtractor.isArrayOfNonprimitives(clazz) ? clazz.getComponentType() : clazz).filter(clazz -> !PojoExtractor.isArrayOfPrimitives(clazz)).filter(PojoExtractor::isNotBasicJavaType).filter(PojoExtractor::isNotEnum).collect(Collectors.toSet());
    }

    private static Set<Class<?>> extractNestedTypes(Class<?> clazz) {
        Class<?> baseClass = clazz;
        HashSet nestedClasses = new HashSet();
        if (PojoExtractor.isArrayOfPrimitives(baseClass)) {
            return nestedClasses;
        }
        if (PojoExtractor.isArrayOfNonprimitives(baseClass)) {
            baseClass = clazz.getComponentType();
        }
        if (PojoExtractor.isNotBasicJavaType(baseClass) && PojoExtractor.isNotEnum(baseClass)) {
            nestedClasses.add(baseClass);
            Set<Class<?>> typesOfFields = PojoExtractor.getTypesOfFields(baseClass);
            nestedClasses.addAll(typesOfFields);
            nestedClasses.addAll(PojoExtractor.collectNestedTypes(typesOfFields));
        }
        return nestedClasses;
    }

    private static Set<Class<?>> getTypesOfFields(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isSynthetic()).map(Field::getType).collect(Collectors.toSet());
    }

    private static Set<Class<?>> collectNestedTypes(Collection<Class<?>> classes) {
        return classes.stream().map(PojoExtractor::extractNestedTypes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static boolean isNotBasicJavaType(Class<?> clazz) {
        return !PojoExtractor.isPrimitive(clazz) && !PojoExtractor.isFromJdk(clazz);
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    private static boolean isFromJdk(Class<?> clazz) {
        return clazz.getPackage().getName().startsWith("java");
    }

    private static boolean isNotEnum(Class<?> clazz) {
        return !clazz.isEnum();
    }

    private static boolean isArrayOfPrimitives(Class<?> clazz) {
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    private static boolean isArrayOfNonprimitives(Class<?> clazz) {
        return clazz.isArray() && !clazz.getComponentType().isPrimitive();
    }
}

