/*
 * Decompiled with CFR 0.152.
 */
package com.hltech.vaunt.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.customProperties.ValidationSchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.hltech.vaunt.core.VauntSerializationException;
import com.hltech.vaunt.core.domain.model.Contract;
import com.hltech.vaunt.core.domain.model.Service;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

public class VauntSerializer {
    private final ObjectMapper mapper = new ObjectMapper();
    private final SchemaFactoryWrapper wrapper;
    private final JsonSchemaGenerator generator;

    public VauntSerializer() {
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.wrapper = new ValidationSchemaFactoryWrapper();
        this.generator = new JsonSchemaGenerator(this.mapper, this.wrapper);
    }

    public JsonSchema generateSchema(Class<?> type) throws JsonMappingException {
        this.wrapper.setVisitorContext((VisitorContext)new VauntVisitorContext());
        return this.generator.generateSchema(type);
    }

    public String serialize(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw new VauntSerializationException("Error during serialization of class: " + object.getClass().getName(), ex);
        }
    }

    public Service readServiceDefinition(File file) {
        try {
            return (Service)this.mapper.readValue(file, Service.class);
        }
        catch (IOException ex) {
            throw new VauntSerializationException("Error during reading service definition from file: " + file.getAbsolutePath(), ex);
        }
    }

    public List<Contract> parseContracts(String contracts) {
        try {
            return (List)this.mapper.readValue(contracts, (TypeReference)new TypeReference<List<Contract>>(){});
        }
        catch (IOException ex) {
            throw new VauntSerializationException("Error during parsing contracts", ex);
        }
    }

    public void serializeToFile(File resultFile, Object value) {
        try {
            this.mapper.writeValue(resultFile, value);
        }
        catch (IOException ex) {
            throw new VauntSerializationException("Error during serialization to file", ex);
        }
    }

    class VauntVisitorContext
    extends VisitorContext {
        private final HashSet<JavaType> seenSchemas = new HashSet();

        VauntVisitorContext() {
        }

        public String addSeenSchemaUri(JavaType seenSchema) {
            if (seenSchema != null && !seenSchema.isPrimitive()) {
                this.seenSchemas.add(seenSchema);
                return this.javaTypeToUrn(seenSchema);
            }
            return null;
        }

        public String getSeenSchemaUri(JavaType seenSchema) {
            if (seenSchema.isTypeOrSubTypeOf(JsonSchema.class)) {
                return this.seenSchemas.contains(seenSchema) ? this.javaTypeToUrn(seenSchema) : null;
            }
            return null;
        }

        public String javaTypeToUrn(JavaType jt) {
            return jt.getRawClass().getSimpleName();
        }
    }
}

