/*
 * Decompiled with CFR 0.152.
 */
package com.hmsonline.json.transformer;

import com.hmsonline.json.transformer.InvalidTransformerException;
import com.hmsonline.json.transformer.JsonRuleCondition;
import com.hmsonline.json.transformer.JsonTransformer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonRule
implements JsonTransformer {
    private JsonRuleCondition cond;
    private JsonTransformer transformer;

    public JsonRule(JsonRuleCondition cond, JsonTransformer transformer) throws InvalidTransformerException {
        this.cond = cond;
        this.transformer = transformer;
    }

    public void transform(JSONObject root, Object targetKey) {
        this.transform(root.get(targetKey));
    }

    public void transform(Object target) {
        if (target instanceof JSONObject) {
            this.transform((JSONObject)target);
        } else if (target instanceof JSONArray) {
            this.transform((JSONArray)target);
        }
    }

    public void transform(JSONObject root) {
        Object[] keySet;
        for (Object k : keySet = root.keySet().toArray()) {
            if (this.cond.check(k.toString())) {
                this.transformer.transform(root, k);
            }
            if (!this.cond.isRecursive()) continue;
            this.transform(root, k);
        }
    }

    private void transform(JSONArray root) {
        int size = root.size();
        for (int i = 0; i < size; ++i) {
            Object target = root.get(i);
            if (!(target instanceof JSONObject)) continue;
            this.transform((JSONObject)target);
        }
    }

    public boolean check(String fieldName) {
        if (this.cond != null) {
            return this.cond.check(fieldName);
        }
        return true;
    }
}

