/*
 * Decompiled with CFR 0.152.
 */
package com.hmsonline.json.transformer;

import com.hmsonline.json.transformer.InvalidTransformerException;
import com.hmsonline.json.transformer.JsonLimitAction;
import com.hmsonline.json.transformer.JsonRemoveAction;
import com.hmsonline.json.transformer.JsonRule;
import com.hmsonline.json.transformer.JsonRuleCondition;
import com.hmsonline.json.transformer.JsonRuleList;
import com.hmsonline.json.transformer.JsonTransformer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JsonTransformerFactory {
    public static JsonTransformer factory(String json) throws InvalidTransformerException {
        return JsonTransformerFactory.factory(JSONValue.parse((String)json));
    }

    public static JsonRule factory(JSONObject json) throws InvalidTransformerException {
        if (json.keySet().size() != 1) {
            throw new InvalidTransformerException(json.toString());
        }
        String key = json.keySet().iterator().next().toString();
        Object value = json.get((Object)key);
        JsonRuleCondition cond = new JsonRuleCondition(key);
        JsonTransformer transformer = JsonTransformerFactory.factory(value);
        return new JsonRule(cond, transformer);
    }

    public static JsonRuleList factory(JSONArray jsonArray) throws InvalidTransformerException {
        JsonRuleList rules = new JsonRuleList();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject json = (JSONObject)jsonArray.get(i);
            rules.addRule(JsonTransformerFactory.factory(json));
        }
        return rules;
    }

    public static JsonTransformer factoryAction(String action) throws InvalidTransformerException {
        if (action.equals("REMOVE")) {
            return new JsonRemoveAction();
        }
        if (action.startsWith("LIMIT ")) {
            return new JsonLimitAction(action.substring(6));
        }
        throw new InvalidTransformerException("Not supported transformer action: " + action);
    }

    private static JsonTransformer factory(Object jsonObject) throws InvalidTransformerException {
        if (jsonObject instanceof JSONObject) {
            return JsonTransformerFactory.factory((JSONObject)jsonObject);
        }
        if (jsonObject instanceof JSONArray) {
            return JsonTransformerFactory.factory((JSONArray)jsonObject);
        }
        if (jsonObject instanceof String) {
            return JsonTransformerFactory.factoryAction((String)jsonObject);
        }
        throw new InvalidTransformerException("Not supported transformer type: " + jsonObject);
    }
}

