/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.EngineType;
import com.holmos.webtest.SeleniumDriver;
import com.holmos.webtest.asynchronous.AsynchronousOpen;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.utils.HolmosBaseUtils;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class WebDriverBrowserWindow
implements BrowserWindow {
    private boolean isLoaded;
    private String windowHandle;
    private EngineType enginetype;
    private SeleniumDriver driver;

    public WebDriverBrowserWindow(SeleniumDriver driver) {
        this.driver = driver;
        this.enginetype = driver.getType();
        this.isLoaded = false;
    }

    @Override
    public String getHandle() {
        return this.windowHandle;
    }

    public void setWidowHandle(String widowHandle) {
        this.windowHandle = widowHandle;
    }

    public void setDriver(SeleniumDriver driver) {
        this.driver = driver;
    }

    @Override
    public SeleniumDriver getDriver() {
        return this.driver;
    }

    @Override
    public String getUrl() {
        this.focus();
        return ((WebDriver)this.driver.getEngine()).getCurrentUrl();
    }

    @Override
    public void refresh() {
        this.isLoaded = false;
        this.focus();
        ((WebDriver)this.driver.getEngine()).navigate().refresh();
        this.isLoaded = true;
    }

    @Override
    public void close() {
        this.focus();
        ((WebDriver)this.driver.getEngine()).close();
        Allocator.getInstance().getWindows().remove(this);
        HolmosBaseUtils.killProcess("chromedriver.exe");
        HolmosBaseUtils.killProcess("IEDriverServer.exe");
    }

    @Override
    public void goForward() {
        this.isLoaded = false;
        this.focus();
        ((WebDriver)this.driver.getEngine()).navigate().forward();
        this.isLoaded = true;
    }

    @Override
    public void goBack() {
        this.isLoaded = false;
        this.focus();
        ((WebDriver)this.driver.getEngine()).navigate().back();
        this.isLoaded = true;
    }

    @Override
    public EngineType getEngineType() {
        return this.enginetype;
    }

    @Override
    public void open(String url) {
        this.isLoaded = false;
        this.focus();
        AsynchronousOpen getThread = new AsynchronousOpen(this, url);
        getThread.start();
        int count = 0;
        while (count++ < ConfigConstValue.defaultWaitCount) {
            if (getThread.isGetSucceed()) break;
            HolmosBaseUtils.sleep(1000);
        }
        if (count > ConfigConstValue.defaultWaitCount) {
            System.out.println("\u9875\u9762\u52a0\u8f7d\u8d85\u65f6\u4e86!\u4f46\u662fcase\u7ee7\u7eed\u6267\u884c\u4e86\uff0c\u4e0d\u5f71\u54cd~");
        }
    }

    @Override
    public void focus() {
        if (Allocator.getInstance().currentWindow.equals(this)) {
            return;
        }
        ((WebDriver)this.driver.getEngine()).switchTo().window(this.getHandle());
        Allocator.getInstance().currentWindow = this;
    }

    @Override
    public void maxSizeWindow() {
        int width = Toolkit.getDefaultToolkit().getScreenSize().width;
        int height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.focus();
        this.moveWindowTo(0, 0);
        this.resizeTo(width, height);
    }

    @Override
    public void moveWindowTo(int xLocation, int yLocation) {
        this.focus();
        StringBuilder message = new StringBuilder("\u79fb\u52a8\u7a97\u53e3\u4f4d\u7f6e");
        if (xLocation >= 0 && yLocation >= 0) {
            message.append("x:" + xLocation + "  y:" + yLocation);
            ((WebDriver)this.driver.getEngine()).manage().window().setPosition(new Point(xLocation, yLocation));
            logger.info(message);
        } else {
            message.append("\u7a97\u53e3\u4f4d\u7f6e\u8bbe\u7f6e\u9519\u8bef\uff01");
            logger.error(message);
        }
    }

    @Override
    public void resizeTo(int horizonSize, int verticalSize) {
        this.focus();
        StringBuilder message = new StringBuilder("\u7a97\u53e3\u91cd\u65b0\u8bbe\u7f6e\u5927\u5c0f");
        if (horizonSize >= 0 && verticalSize >= 0) {
            message.append("\u5bbd\u5ea6:" + horizonSize + "  \u9ad8\u5ea6:" + verticalSize);
            ((WebDriver)this.driver.getEngine()).manage().window().setSize(new Dimension(horizonSize, verticalSize));
            logger.info(message);
        } else {
            message.append("\u7a97\u53e3\u5927\u5c0f\u8bbe\u7f6e\u9519\u8bef\uff01");
            logger.error(message);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public String dealAlert() {
        String alertMessage = null;
        this.focus();
        try {
            Alert alert = ((WebDriver)this.getDriver().getEngine()).switchTo().alert();
            alertMessage = alert.getText();
            alert.accept();
            return alertMessage;
        }
        catch (Exception e) {
            logger.error("\u6ca1\u6709\u627e\u5230Alert\u7a97\u53e3!");
            return null;
        }
    }

    @Override
    public String dealPrompt(String input, boolean isYes) {
        String promptMessage = null;
        this.focus();
        try {
            Alert alert = ((WebDriver)this.getDriver().getEngine()).switchTo().alert();
            alert.sendKeys(input);
            promptMessage = alert.getText();
            if (isYes) {
                alert.accept();
            } else {
                alert.dismiss();
            }
            return promptMessage;
        }
        catch (Exception e) {
            logger.error("\u6ca1\u6709\u627e\u5230Prompt\u7a97\u53e3!");
            return null;
        }
    }

    @Override
    public String dealConfirm(boolean isYes) {
        String confirmMessage = null;
        this.focus();
        try {
            Alert alert = ((WebDriver)this.getDriver().getEngine()).switchTo().alert();
            confirmMessage = alert.getText();
            if (isYes) {
                alert.accept();
            } else {
                alert.dismiss();
            }
            return confirmMessage;
        }
        catch (Exception e) {
            logger.error("\u6ca1\u6709\u627e\u5230Prompt\u7a97\u53e3!");
            return null;
        }
    }

    @Override
    public void openNewWindow(String url) {
        this.open(url);
        this.windowHandle = ((WebDriver)this.driver.getEngine()).getWindowHandle();
    }

    @Override
    public void quit() {
        ((WebDriver)this.driver.getEngine()).quit();
    }

    @Override
    public void TakeScreenshot(String fileName) {
        TakesScreenshot TCS = (TakesScreenshot)((WebDriver)this.driver.getEngine());
        File screenShot = (File)TCS.getScreenshotAs(OutputType.FILE);
        try {
            FileUtils.copyFile((File)screenShot, (File)new File(String.valueOf(Allocator.getInstance().getScreenShotDir()) + fileName));
            logger.info("\u622a\u56fe\u6210\u529f!");
        }
        catch (IOException e) {
            logger.error("\u622a\u56fe\u5931\u8d25!");
            e.printStackTrace();
        }
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.focus();
        ((WebDriver)this.driver.getEngine()).manage().addCookie(cookie);
    }

    @Override
    public Set<Cookie> getAllCookies() {
        return ((WebDriver)this.driver.getEngine()).manage().getCookies();
    }

    @Override
    public Cookie getCookieByName(String name) {
        return ((WebDriver)this.driver.getEngine()).manage().getCookieNamed(name);
    }

    @Override
    public void removeCookieByName(String name) {
        ((WebDriver)this.driver.getEngine()).manage().deleteCookieNamed(name);
    }

    @Override
    public void removeAllCookies() {
        ((WebDriver)this.driver.getEngine()).manage().deleteAllCookies();
    }

    public void removeCookie(Cookie cookie) {
        ((WebDriver)this.driver.getEngine()).manage().deleteCookie(cookie);
    }

    @Override
    public String getTitle() {
        this.focus();
        return ((WebDriver)this.driver.getEngine()).getTitle();
    }

    @Override
    public void setHandle(String handle) {
        this.windowHandle = handle;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }
}

