/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.asserttool;

import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.log.MyLogger;
import java.util.regex.Pattern;

public class HolmosSimpleCheckTool {
    private static MyLogger logger = MyLogger.getLogger(HolmosSimpleCheckTool.class);

    public static void assertTrue(boolean condition) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertTrue(boolean condition):\n");
        if (!condition) {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3afalse!");
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3atrue\uff01");
        logger.info(msg);
    }

    public static void assertTrue(boolean condition, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertTrue(boolean conditio,String message):\n");
        if (!condition) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3afalse!");
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3atrue\uff01");
        logger.info(msg);
    }

    public static void assertFalse(boolean condition) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertFalse(boolean condition):\n");
        if (condition) {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3atrue!");
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3afalse\uff01");
        logger.info(msg);
    }

    public static void assertFalse(boolean condition, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertFalse(boolean condition,String message):\n");
        if (condition) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3atrue!");
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3afalse\uff01");
        logger.info(msg);
    }

    public static void assertEqual(boolean actual, boolean expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(boolean actual,boolean expect):\n");
        if (actual != expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(boolean actual, boolean expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(boolean actual,boolean expect,String message):\n");
        if (actual != expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(double actual, double expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(double actual,double expect):\n");
        if (actual != expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(double actual, double expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(double actual,double expect,String message):\n");
        if (actual != expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(long actual, long expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(long actual,long expect):\n");
        if (actual != expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(long actual, long expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(long actual,long expect,String message):\n");
        if (actual != expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(char actual, char expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(char actual,char expect):\n");
        if (actual != expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(char actual, char expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder(":\n");
        if (actual != expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(String actual, String expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(String actual,String expect):\n");
        if (!actual.equalsIgnoreCase(expect)) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertEqual(String actual, String expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertEqual(String actual,String expect,String message):\n");
        if (!actual.equalsIgnoreCase(expect)) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(boolean actual, boolean expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(boolean actual,boolean expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(boolean actual, boolean expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(boolean actual,boolean expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(double actual, double expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(double actual,double expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(double actual, double expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(double actual,double expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(long actual, long expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(long actual,long expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(long actual, long expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(long actual,long expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(char actual, char expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(char actual,char expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(char actual, char expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(char actual,char expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(String actual, String expect) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(String actual,String expect):\n");
        if (actual.equalsIgnoreCase(expect)) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertNotEqual(String actual, String expect, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotEqual(String actual,String expect,String message):\n");
        if (actual.equalsIgnoreCase(expect)) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
        logger.info(msg);
    }

    public static void assertInclude(String content, String included) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertInclude(String content,String included):\n");
        if (!content.contains(included)) {
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
        logger.info(msg);
    }

    public static void assertInclude(String content, String included, String message) {
        StringBuilder msg = new StringBuilder("assertInclude(String content,String included,String message):\n");
        if (!content.contains(included)) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
        logger.info(msg);
    }

    public static void assertNotInclude(String content, String included) {
        StringBuilder msg = new StringBuilder("assertNotInclude(String content,String included):\n");
        if (content.contains(included)) {
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
        logger.info(msg);
    }

    public static void assertNotInclude(String content, String included, String message) {
        StringBuilder msg = new StringBuilder("assertNotInclude(String content,String included,String message):\n");
        if (content.contains(included)) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
        logger.info(msg);
    }

    public static void assertMatch(String regex, String matcher) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertMatch(String actual,String expect):\n");
        if (!Pattern.matches(regex, matcher)) {
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
        logger.info(msg);
    }

    public static void assertMatch(String regex, String matcher, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertMatch(String actual,String expect,String message):\n");
        if (!Pattern.matches(regex, matcher)) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
        logger.info(msg);
    }

    public static void assertNotMatch(String regex, String matcher) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotMatch(String actual,String expect):\n");
        if (Pattern.matches(regex, matcher)) {
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
        logger.info(msg);
    }

    public static void assertNotMatch(String regex, String matcher, String message) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("assertNotMatch(String actual,String expect,String message):\n");
        if (!Pattern.matches(regex, matcher)) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
        logger.info(msg);
    }

    public static void assertStartWith(String content, String prefix) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("verifyStartWith(String content,String prefix)");
        if (!content.startsWith(prefix)) {
            msg.append("\u524d\u7f00\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u524d\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + prefix);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u524d\u7f00\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u524d\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + prefix);
        logger.info(msg);
    }

    public static void assertEndWith(String content, String endfix) throws HolmosFailedError {
        StringBuilder msg = new StringBuilder("verifyStartWith(String content,String prefix)");
        if (!content.startsWith(content)) {
            msg.append("\u540e\u7f00\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u540e\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + content);
            throw new HolmosFailedError(msg.toString());
        }
        msg.append("\u540e\u7f00\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u540e\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + content);
        logger.info(msg);
    }

    public static void verifyTrue(boolean condition) {
        StringBuilder msg = new StringBuilder("verifyTrue(boolean condition):\n");
        if (condition) {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3atrue\uff01");
            logger.info(msg);
        } else {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3afalse!");
            logger.error(msg);
        }
    }

    public static void verifyTrue(boolean condition, String message) {
        StringBuilder msg = new StringBuilder("verifyTrue(boolean condition,String message):\n");
        if (condition) {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3atrue\uff01");
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3afalse!");
            logger.error(msg);
        }
    }

    public static void verifyFalse(boolean condition) {
        StringBuilder msg = new StringBuilder("verifyFalse(boolean condition):\n");
        if (!condition) {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3afalse\uff01");
            logger.info(msg);
        } else {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3atrue!");
            logger.error(msg);
        }
    }

    public static void verifyFalse(boolean condition, String message) {
        StringBuilder msg = new StringBuilder("verifyFalse(boolean condition,String message):\n");
        if (!condition) {
            msg.append("\u6761\u4ef6\u6821\u9a8c\u6b63\u786e\uff01\u5b9e\u9645\u503c\u4e3afalse\uff01");
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6761\u4ef6\u6821\u9a8c\u9519\u8bef\uff01\u5b9e\u9645\u503c\u4e3atrue!");
            logger.error(msg);
        }
    }

    public static void verifyEqual(boolean actual, boolean expect) {
        StringBuilder msg = new StringBuilder("verifyEqual(boolean actual,boolean expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(boolean actual, boolean expect, String message) {
        StringBuilder msg = new StringBuilder("verifyEqual(boolean actual,boolean expect,String message):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(double actual, double expect) {
        StringBuilder msg = new StringBuilder("verifyEqual(double actual,double expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(double actual, double expect, String message) {
        StringBuilder msg = new StringBuilder("verifyEqual(double actual,double expect,String message):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(long actual, long expect) {
        StringBuilder msg = new StringBuilder("verifyEqual(long actual,long expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(long actual, long expect, String message) {
        StringBuilder msg = new StringBuilder("verifyEqual(long actual,long expect,String message):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(char actual, char expect) {
        StringBuilder msg = new StringBuilder("verifyEqual(char actual,char expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(char actual, char expect, String message) {
        StringBuilder msg = new StringBuilder(":\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(String actual, String expect) {
        StringBuilder msg = new StringBuilder("verifyEqual(String actual,String expect):\n");
        if (actual.equalsIgnoreCase(expect)) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyEqual(String actual, String expect, String message) {
        StringBuilder msg = new StringBuilder("verifyEqual(String actual,String expect,String message):\n");
        if (actual.equalsIgnoreCase(expect)) {
            msg.append("\u6821\u9a8c\u6b63\u786e\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.error(msg);
        }
    }

    public static void verifyNotEqual(boolean actual, boolean expect) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(boolean actual,boolean expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(boolean actual, boolean expect, String message) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(boolean actual,boolean expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(double actual, double expect) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(double actual,double expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(double actual, double expect, String message) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(double actual,double expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(long actual, long expect) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(long actual,long expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(long actual, long expect, String message) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(long actual,long expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(char actual, char expect) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(char actual,char expect):\n");
        if (actual == expect) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(char actual, char expect, String message) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(char actual,char expect,String message):\n");
        if (actual == expect) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(String actual, String expect) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(String actual,String expect):\n");
        if (actual.equalsIgnoreCase(expect)) {
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyNotEqual(String actual, String expect, String message) {
        StringBuilder msg = new StringBuilder("verifyNotEqual(String actual,String expect,String message):\n");
        if (actual.equalsIgnoreCase(expect)) {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u6821\u9a8c\u5931\u8d25\uff01\u9884\u671f\u503c\u548c\u5b9e\u9645\u503c\u5747\u4e3a:" + actual);
            logger.error(msg);
        } else {
            msg.append("\u6821\u9a8c\u6210\u529f\uff01\u9884\u671f\u503c\u4e3a\uff1a" + expect + "\u5b9e\u9645\u503c\u4e3a\uff1a" + actual);
            logger.info(msg);
        }
    }

    public static void verifyInclude(String content, String included) {
        StringBuilder msg = new StringBuilder("verifyInclude(String content,String included):\n");
        if (content.contains(included)) {
            msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.info(msg);
        } else {
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
        }
    }

    public static void verifyInclude(String content, String included, String message) {
        StringBuilder msg = new StringBuilder("verifyInclude(String content,String included,String message):\n");
        if (content.contains(included)) {
            msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
        }
    }

    public static void verifyNotInclude(String content, String included) {
        StringBuilder msg = new StringBuilder("verifyNotInclude(String content,String included):\n");
        if (!content.contains(included)) {
            msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.info(msg);
        } else {
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
        }
    }

    public static void verifyNotInclude(String content, String included, String message) {
        StringBuilder msg = new StringBuilder("verifyNotInclude(String content,String included,String message):\n");
        if (!content.contains(included)) {
            msg.append("\u5305\u542b\u6821\u9a8c\u6b63\u786e\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25\uff0c\u6821\u9a8c\u5b57\u7b26\u7a9c\u4e3a\uff1a" + content + "\n\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a\uff1a" + included);
            logger.error(msg);
        }
    }

    public static void verifyMatch(String regex, String matcher) {
        StringBuilder msg = new StringBuilder("verifyMatch(String actual,String expect):\n");
        if (Pattern.matches(regex, matcher)) {
            msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.info(msg);
        } else {
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
        }
    }

    public static void verifyMatch(String regex, String matcher, String message) {
        StringBuilder msg = new StringBuilder("verifyMatch(String actual,String expect,String message):\n");
        if (Pattern.matches(regex, matcher)) {
            msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
        }
    }

    public static void verifyNotMatch(String regex, String matcher) {
        StringBuilder msg = new StringBuilder("verifyNotMatch(String actual,String expect):\n");
        if (!Pattern.matches(regex, matcher)) {
            msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.info(msg);
        } else {
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
        }
    }

    public static void verifyNotMatch(String regex, String matcher, String message) {
        StringBuilder msg = new StringBuilder("verifyNotMatch(String actual,String expect,String message):\n");
        if (Pattern.matches(regex, matcher)) {
            msg.append("\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.info(msg);
        } else {
            msg.append(String.valueOf(message) + ":");
            msg.append("\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + matcher + "\u6821\u9a8c\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regex);
            logger.error(msg);
        }
    }

    public static void verifyStartWith(String content, String prefix) {
        StringBuilder msg = new StringBuilder("verifyStartWith(String content,String prefix)");
        if (content.startsWith(prefix)) {
            msg.append("\u524d\u7f00\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u524d\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + prefix);
            logger.info(msg);
        } else {
            msg.append("\u524d\u7f00\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u524d\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + prefix);
            logger.error(msg);
        }
    }

    public static void verifyEndWith(String content, String endfix) {
        StringBuilder msg = new StringBuilder("verifyStartWith(String content,String prefix)");
        if (content.startsWith(content)) {
            msg.append("\u540e\u7f00\u5339\u914d\u6821\u9a8c\u6210\u529f\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u540e\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + content);
            logger.info(msg);
        } else {
            msg.append("\u540e\u7f00\u5339\u914d\u6821\u9a8c\u5931\u8d25\uff01\u5f85\u6821\u9a8c\u7684\u5b57\u7b26\u7a9c\u4e3a:" + content + "\u6821\u9a8c\u7684\u540e\u7f00\u8868\u8fbe\u5f0f\u4e3a:" + content);
            logger.error(msg);
        }
    }
}

