/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.constvalue;

import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.utils.HolmosPropertiesUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;

public class ConfigConstValue {
    private static MyLogger logger = MyLogger.getLogger(ConfigConstValue.class);
    private static String CONFNAME = "holmosconf";
    private static String CONFDIR;
    public static String UPLOADFILE;
    public static String CLOSEWINDOW;
    public static String DOWNLOADFILE;
    public static String IEDRIVER;
    public static String CHROMEDRIVER;
    public static String CSSPROPERTIESCONFIG;
    public static String IMGCSSPROPERTIESCONFIG;
    public static String HOLMOSCONFFILE;
    public static String CURRENTWORKTOPACKAGEPATH;
    public static int defaulwaitMiliSeconds;
    public static int defaultWaitCount;
    public static int waitCount;
    public static int waitPageLoadTime;
    public static String AUTOITDLLPATH;
    public static final String DATA_SOURCE_PACKAGE_PREFIX_USEABLE = "Holmos.data.source.package.prefix.useable";
    public static final String DATA_SOURCE_PREFIX_VALUE = "Holmos.data.source.prefix.value";

    static {
        CURRENTWORKTOPACKAGEPATH = "\\src\\test\\java\\";
        defaulwaitMiliSeconds = 50;
        defaultWaitCount = 100;
        waitCount = 200;
        waitPageLoadTime = 10000;
        try {
            ConfigConstValue.initHolmosConf();
            if (HOLMOSCONFFILE != null) {
                Properties properties = HolmosPropertiesUtils.getPropertyInfo(HOLMOSCONFFILE);
                defaulwaitMiliSeconds = HolmosPropertiesUtils.getInt(properties, "defaulwaitMiliSeconds");
                defaultWaitCount = HolmosPropertiesUtils.getInt(properties, "defaultWaitCount");
                waitCount = HolmosPropertiesUtils.getInt(properties, "waitCount");
                waitPageLoadTime = HolmosPropertiesUtils.getInt(properties, "waitPageLoadTime");
                CURRENTWORKTOPACKAGEPATH = HolmosPropertiesUtils.getValue(properties, "currentWorkToPackageDir");
                HOLMOSCONFFILE = URLDecoder.decode(HOLMOSCONFFILE, "utf8");
                UPLOADFILE = URLDecoder.decode(UPLOADFILE, "utf8");
                DOWNLOADFILE = URLDecoder.decode(DOWNLOADFILE, "utf8");
                IEDRIVER = URLDecoder.decode(IEDRIVER, "utf8");
                CHROMEDRIVER = URLDecoder.decode(CHROMEDRIVER, "utf8");
                CSSPROPERTIESCONFIG = URLDecoder.decode(CSSPROPERTIESCONFIG, "utf8");
                IMGCSSPROPERTIESCONFIG = URLDecoder.decode(IMGCSSPROPERTIESCONFIG, "utf8");
                CURRENTWORKTOPACKAGEPATH = URLDecoder.decode(CURRENTWORKTOPACKAGEPATH, "utf8");
                System.setProperty("webdriver.ie.driver", IEDRIVER);
                System.setProperty("webdriver.chrome.driver", CHROMEDRIVER);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private static void initResourcesConf() {
        File conf = new File(String.valueOf(ClassLoader.getSystemResource("").getPath().substring(1)) + CONFNAME);
        if (conf.exists() && conf.isDirectory()) {
            CONFDIR = conf.getAbsolutePath();
        }
    }

    private static void initProjectBaseConf() {
        File conf = new File(String.valueOf(System.getProperty("user.dir")) + "\\" + CONFNAME);
        if (conf.exists() && conf.isDirectory()) {
            CONFDIR = conf.getAbsolutePath();
        }
    }

    private static void initUserDirBaseConf() {
        File conf = new File(String.valueOf(System.getProperty("user.home")) + "\\" + CONFNAME);
        if (conf.exists() && conf.isDirectory()) {
            CONFDIR = conf.getAbsolutePath();
        }
    }

    private static void initCConf() {
        File conf = new File("C:\\" + CONFNAME);
        if (conf.exists() && conf.isDirectory()) {
            CONFDIR = conf.getAbsolutePath();
        }
    }

    private static void initHolmosConf() {
        ConfigConstValue.initResourcesConf();
        ConfigConstValue.initProjectBaseConf();
        ConfigConstValue.initUserDirBaseConf();
        ConfigConstValue.initCConf();
        if (CONFDIR == null) {
            logger.warn("holmos\u7684\u914d\u7f6e\u6587\u4ef6\u6ca1\u6709\u52a0\u8f7d\u6210\u529f!\u5c06\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e!\n\u60a8\u9700\u8981\u81ea\u884c\u914d\u7f6echromedriver\u548cIEDDriverServer:\u914d\u7f6e\u65b9\u6cd5\u8bf7\u53c2\u8003:http://wd.holmos.com/?/question/1015\n\u60a8\u5c06\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528\u4ee5\u4e0b\u529f\u80fd:\n(1)web\u9875\u9762\u7684\u4e0a\u4f20\u548c\u4e0b\u8f7d\u529f\u80fd(2)\u65e0\u6cd5\u6b63\u5e38\u7528Holmos\u6765\u8fdb\u884c\u9875\u9762\u6837\u5f0f\u7684\u6821\u9a8c\n\u5176\u4ed6\u6240\u6709\u7684\u529f\u80fd\uff0c\u5747\u4e0d\u9020\u6210\u4efb\u4f55\u5f71\u54cd!\u8bf7\u60a8\u653e\u5fc3\u4f7f\u7528\uff0c\u5982\u6709\u95ee\u9898\uff0c\u8bf7\u627e\u94f6\u9f99!");
        } else {
            UPLOADFILE = String.valueOf(CONFDIR) + "\\autoItScripts\\upload.exe";
            DOWNLOADFILE = String.valueOf(CONFDIR) + "\\autoItScripts\\download.exe";
            CLOSEWINDOW = String.valueOf(CONFDIR) + "\\autoItScripts\\closewindow.exe";
            IEDRIVER = String.valueOf(CONFDIR) + "\\driverServers\\IEDriverServer.exe";
            CHROMEDRIVER = String.valueOf(CONFDIR) + "\\driverServers\\chromedriver.exe";
            CSSPROPERTIESCONFIG = String.valueOf(CONFDIR) + "\\cssProperties\\css_comman_property_config.properties";
            IMGCSSPROPERTIESCONFIG = String.valueOf(CONFDIR) + "\\cssProperties\\css_img_property_config.properties";
            HOLMOSCONFFILE = String.valueOf(CONFDIR) + "\\holmosConf.properties";
        }
    }
}

