/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.element.Element;
import com.holmos.webtest.utils.HolmosWindow;
import com.thoughtworks.selenium.Selenium;
import org.junit.Assert;

public class CheckBox
extends Element {
    public CheckBox(String comment) {
        super(comment);
    }

    public boolean isChecked() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        boolean checked = false;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                checked = ((Selenium)currentWindow.getDriver().getEngine()).isChecked(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                checked = this.element.isSelected();
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u68c0\u9a8c\u9009\u4e2d\u5931\u8d25\uff01\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
        return checked;
    }

    public void setValue(boolean value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                if (((Selenium)currentWindow.getDriver().getEngine()).isChecked(this.locator.getSeleniumCurrentLocator()) != value) {
                    ((Selenium)currentWindow.getDriver().getEngine()).click(this.locator.getSeleniumCurrentLocator());
                }
            } else if (currentWindow instanceof WebDriverBrowserWindow && this.element.isSelected() != value) {
                this.element.click();
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u8bbe\u5b9a\u503c\u5931\u8d25\uff01\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void assertChecked() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                if (((Selenium)currentWindow.getDriver().getEngine()).isChecked(this.locator.getSeleniumCurrentLocator())) {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u6210\u529f\uff01\u5f53\u524d\u5904\u4e8e\u9009\u4e2d\u72b6\u6001");
                    this.logger.info(message);
                } else {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u5931\u8d25\uff01\u5f53\u524d\u5904\u4e8e\u672a\u9009\u4e2d\u72b6\u6001");
                    this.logger.error(message);
                    HolmosWindow.closeAllWindows();
                    Assert.fail((String)message.toString());
                }
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                if (this.element.isSelected()) {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u6210\u529f\uff01\u5f53\u524d\u5904\u4e8e\u9009\u4e2d\u72b6\u6001");
                    this.logger.info(message);
                } else {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u5931\u8d25\uff01\u5f53\u524d\u5904\u4e8e\u672a\u9009\u4e2d\u72b6\u6001");
                    this.logger.error(message);
                    HolmosWindow.closeAllWindows();
                    Assert.fail((String)message.toString());
                }
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u5931\u8d25\uff01\u5f53\u524d\u5904\u4e8e\u672a\u9009\u4e2d\u72b6\u6001");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void verifyChecked() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                if (((Selenium)currentWindow.getDriver().getEngine()).isChecked(this.locator.getSeleniumCurrentLocator())) {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u6210\u529f\uff01\u5f53\u524d\u5904\u4e8e\u9009\u4e2d\u72b6\u6001");
                    this.logger.info(message);
                } else {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u5931\u8d25\uff01\u5f53\u524d\u5904\u4e8e\u672a\u9009\u4e2d\u72b6\u6001");
                    this.logger.error(message);
                    HolmosWindow.closeAllWindows();
                    Assert.fail((String)message.toString());
                }
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                if (this.element.isSelected()) {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u6210\u529f\uff01\u5f53\u524d\u5904\u4e8e\u9009\u4e2d\u72b6\u6001");
                    this.logger.info(message);
                } else {
                    message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u5931\u8d25\uff01\u5f53\u524d\u5904\u4e8e\u672a\u9009\u4e2d\u72b6\u6001");
                    this.logger.error(message);
                    HolmosWindow.closeAllWindows();
                    Assert.fail((String)message.toString());
                }
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6821\u9a8c\u591a\u9009\u6846\u9009\u4e2d\u5931\u8d25\uff01\u5f53\u524d\u5904\u4e8e\u672a\u9009\u4e2d\u72b6\u6001");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    private void waitForValue(boolean value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int waitStep = 0;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                while (waitStep++ < ConfigConstValue.waitCount) {
                    if (((Selenium)currentWindow.getDriver().getEngine()).isChecked(this.locator.getSeleniumCurrentLocator()) == value) break;
                }
                if (waitStep > ConfigConstValue.waitCount) {
                    message.append("\u7b49\u5f85\u65f6\u95f430s,\u72b6\u6001\u6ca1\u6709\u53d8\u4e3a" + (value ? "\u9009\u4e2d" : "\u672a\u9009\u4e2d"));
                    this.logger.error(message);
                }
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                while (waitStep++ < ConfigConstValue.waitCount) {
                    if (this.element.isSelected() == value) break;
                }
                if (waitStep > ConfigConstValue.waitCount) {
                    message.append("\u7b49\u5f85\u65f6\u95f430s,\u72b6\u6001\u6ca1\u6709\u53d8\u4e3a" + (value ? "\u9009\u4e2d" : "\u672a\u9009\u4e2d"));
                    this.logger.error(message);
                }
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u65e0\u6cd5\u7b49\u5f85\u5143\u7d20\u7684\u72b6\u6001\u66f4\u6539\uff0c\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    public void waitForChecked() {
        this.waitForValue(true);
    }

    public void waitForUnChecked() {
        this.waitForValue(false);
    }
}

