/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.EngineType;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.asynchronous.AsynchronousClick;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.element.locator.AbstractElement;
import com.holmos.webtest.element.locator.Locator;
import com.holmos.webtest.element.locator.LocatorChain;
import com.holmos.webtest.element.property.Location;
import com.holmos.webtest.element.tool.SeleniumElementExist;
import com.holmos.webtest.element.tool.WebDriverElementExist;
import com.holmos.webtest.element.tool.WebElementExist;
import com.holmos.webtest.log.MyLogger;
import com.holmos.webtest.utils.HolmosBaseUtils;
import com.holmos.webtest.utils.HolmosWindow;
import com.thoughtworks.selenium.Selenium;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class Element
extends AbstractElement {
    protected String wholeComment;
    private boolean isCreatedByFindElements = false;
    protected WebElementExist exist;
    private LocatorChain infoChain = new LocatorChain();
    protected String fullName = "";
    protected String comment;
    protected Locator locator;
    protected String locatorCurrent = "";
    protected WebElement element = null;
    protected MyLogger logger = MyLogger.getLogger(this.getClass());

    public String getWholeComment() {
        return this.wholeComment;
    }

    @Override
    public void setWholeComment(String wholeComment) {
        this.wholeComment = wholeComment;
    }

    @Override
    public LocatorChain getInfoChain() {
        return this.infoChain;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void setElement(WebElement element) {
        this.element = element;
    }

    @Override
    public WebElement getElement() {
        return this.element;
    }

    public Element(String comment) {
        this.comment = comment;
        this.locator = new Locator();
    }

    public void addIDLocator(String id) {
        this.locator.addIdLocator(id);
    }

    public void addNameLocator(String name) {
        this.locator.addNameLocator(name);
    }

    public void addXpathLocator(String xpath) {
        this.locator.addXpathLocator(xpath);
    }

    public void addCSSLocator(String css) {
        this.locator.addCSSLocator(css);
    }

    public void addLinkTextLocator(String linkText) {
        this.locator.addLinkTextLocator(linkText);
    }

    public void addPartialLinkTextLocator(String partialLinkText) {
        this.locator.addPartialLinkTextLocator(partialLinkText);
    }

    public void addAttributeLocator(String attributeName, String attributeValue) {
        this.locator.addAttributeLocator(attributeName, attributeValue);
    }

    public void addTagNameLocator(String tagName) {
        this.locator.addTagNameLocator(tagName);
    }

    public void addClassLocator(String className) {
        this.locator.addClassLocator(className);
    }

    private boolean isElementExist(int waitCount) {
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (currentWindow instanceof WebDriverBrowserWindow) {
            this.exist = new WebDriverElementExist(this);
        } else if (currentWindow instanceof SeleniumBrowserWindow) {
            this.exist = new SeleniumElementExist(this);
        }
        return this.exist.isElementExist(waitCount);
    }

    @Override
    public boolean isExist() {
        return this.isElementExist(ConfigConstValue.defaultWaitCount);
    }

    public void assertExist() {
        StringBuilder message = new StringBuilder();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append(":\u5143\u7d20\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append(":\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u4e0d\u5b58\u5728!");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void assertNotExist() {
        StringBuilder message = new StringBuilder();
        if (!this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u4e0d\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u5b58\u5728!");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void verifyExist() {
        StringBuilder message = new StringBuilder();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u4e0d\u5b58\u5728!");
            this.logger.error(message);
        }
    }

    public void verifyNotExist() {
        StringBuilder message = new StringBuilder();
        if (!this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u4e0d\u5b58\u5728\u6027\u6821\u9a8c\u6210\u529f\uff01\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5143\u7d20\u5b58\u5728\u6821\u9a8c\u5931\u8d25\uff01\u5143\u7d20\u5b58\u5728!");
            this.logger.error(message);
        }
    }

    public boolean waitForExist() {
        if (!this.isElementExist(ConfigConstValue.waitCount)) {
            this.logger.error("\u5143\u7d20" + this.wholeComment + "\u4e00\u76f4\u6ca1\u6709\u51fa\u73b0");
            return false;
        }
        return true;
    }

    public void waitForDisppear() {
        int waitCount = 0;
        while (waitCount++ < ConfigConstValue.waitCount) {
            if (this.exist.isElementExistForCheckOnce()) continue;
            return;
        }
    }

    public void click() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).click(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.element.click();
            }
            message.append("click\u9f20\u6807\u5de6\u952e\u5355\u51fb\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("click\u9f20\u6807\u5de6\u952e\u5355\u51fb\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void clickAndWaitForNewWindow() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).click(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                Set handlesPrior = ((WebDriver)currentWindow.getDriver().getEngine()).getWindowHandles();
                this.element.click();
                try {
                    Set handlesThen = ((WebDriver)currentWindow.getDriver().getEngine()).getWindowHandles();
                    int waitCount = 0;
                    while (this.isHandlesEqual(handlesPrior, handlesThen) && waitCount < ConfigConstValue.defaultWaitCount) {
                        handlesThen = ((WebDriver)currentWindow.getDriver().getEngine()).getWindowHandles();
                        HolmosBaseUtils.sleep(50);
                    }
                    Allocator.getInstance().updateWindows();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            message.append("click\u9f20\u6807\u5de6\u952e\u5355\u51fb\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("click\u9f20\u6807\u5de6\u952e\u5355\u51fb\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    private boolean isHandlesEqual(Set<String> left, Set<String> right) {
        if (left == null || right == null) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        Iterator<String> leftValue = left.iterator();
        Iterator<String> rightValue = right.iterator();
        while (leftValue.hasNext()) {
            if (leftValue.next().equalsIgnoreCase(rightValue.next())) continue;
            return false;
        }
        return true;
    }

    public void setText(String value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).type(this.locator.getSeleniumCurrentLocator(), value);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.element.clear();
                this.element.sendKeys(new CharSequence[]{value});
            }
            message.append("\u8bbe\u7f6e\u503c\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u8bbe\u7f6e\u503c\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    public void clickAndWaitForSecond(int second) {
        AsynchronousClick getThread = new AsynchronousClick(this);
        getThread.start();
        int count = 0;
        while (count++ < second) {
            if (getThread.isGetSucceed()) break;
            HolmosBaseUtils.sleep(1000);
        }
        if (count > second) {
            System.out.println("\u9875\u9762\u52a0\u8f7d\u8d85\u65f6\u4e86!\u4f46\u662fcase\u7ee7\u7eed\u6267\u884c\u4e86\uff0c\u4e0d\u5f71\u54cd~");
        }
    }

    public void clickAndWaitForLoad() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            block18: {
                message.append(String.valueOf(this.wholeComment) + ":");
                if (currentWindow instanceof SeleniumBrowserWindow) {
                    Selenium selenium = (Selenium)currentWindow.getDriver().getEngine();
                    try {
                        String url = selenium.getAttribute(String.valueOf(this.locator.getSeleniumCurrentLocator()) + "@href");
                        if (url.endsWith("#")) {
                            selenium.click(this.locator.getSeleniumCurrentLocator());
                            selenium.waitForPageToLoad(Integer.toString(ConfigConstValue.waitPageLoadTime));
                            break block18;
                        }
                        try {
                            String target = selenium.getAttribute(String.valueOf(this.locator.getSeleniumCurrentLocator()) + "@target");
                            HolmosBaseUtils.openByTarget(url, target);
                        }
                        catch (Exception e) {
                            try {
                                String target = selenium.getAttribute("xpath=/html/head/base@target");
                                HolmosBaseUtils.openByTarget(url, target);
                            }
                            catch (Exception e1) {
                                try {
                                    String target = selenium.getAttribute("xpath=/htm/head/base@target");
                                    HolmosBaseUtils.openByTarget(url, target);
                                }
                                catch (Exception e11) {
                                    HolmosBaseUtils.openByTarget(url, null);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        selenium.click(this.locator.getSeleniumCurrentLocator());
                        selenium.waitForPageToLoad(Integer.toString(ConfigConstValue.waitPageLoadTime));
                    }
                } else if (currentWindow instanceof WebDriverBrowserWindow) {
                    this.element.click();
                    if (Allocator.getInstance().currentWindow.getEngineType().equals((Object)EngineType.WebDriverFirefox)) {
                        ((WebDriver)Allocator.getInstance().currentWindow.getDriver().getEngine()).manage().timeouts().pageLoadTimeout((long)ConfigConstValue.waitPageLoadTime, TimeUnit.MILLISECONDS);
                    } else {
                        HolmosBaseUtils.sleep(1000);
                    }
                    try {
                        Allocator.getInstance().updateWindows();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            message.append("click()\u64cd\u4f5c\u6210\u529f\uff01");
            this.logger.info(message.toString());
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("click()\u9f20\u6807\u5de6\u952e\u5355\u51fb\u64cd\u4f5c\u5931\u8d25\uff01\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void clickAndWaitForUrl(String url) {
        this.click();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int count = 0;
        while (count++ < ConfigConstValue.defaultWaitCount * 10) {
            if (currentWindow.getUrl().equalsIgnoreCase(url)) break;
            HolmosBaseUtils.sleep(50);
        }
    }

    public void clickAndWaitForIncludeUrl(String partUrl) {
        this.click();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        int count = 0;
        while (count++ < ConfigConstValue.defaultWaitCount * 10) {
            if (currentWindow.getUrl().contains(partUrl)) break;
            HolmosBaseUtils.sleep(50);
        }
    }

    public void mouseOver() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).mouseOver(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.moveToElement(this.element).perform();
            }
            message.append("\u60ac\u505c\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u60ac\u505c\u5931\u8d25\uff01\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public String getText() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        String text = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                text = ((Selenium)currentWindow.getDriver().getEngine()).getText(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                text = this.element.getText();
            }
            message.append("\u6587\u672c\u83b7\u5f97\u6210\u529f\uff0c\u4e3a:" + text);
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6587\u672c\u83b7\u5f97\u5931\u8d25\uff0c\u5143\u7d20\u627e\u4e0d\u5230!");
            this.logger.error(message);
        }
        return text;
    }

    public void outputText() {
        System.out.println(this.getText());
    }

    public void focus() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).focus(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.element.sendKeys(new CharSequence[]{""});
            }
            message.append("\u7126\u70b9\u83b7\u5f97\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u7126\u70b9\u83b7\u5f97\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    public void doubleClick() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).doubleClick(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.doubleClick(this.element).perform();
            }
            message.append("\u53cc\u51fb\u64cd\u4f5c\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u53cc\u51fb\u64cd\u4f5c\u5931\u8d25\uff01\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    public void keyPress(Keys keyValue) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).keyPress(this.locator.getSeleniumCurrentLocator(), keyValue.toString());
            } else {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.keyDown(this.element, keyValue).perform();
            }
            message.append("\u6309\u94ae" + keyValue + "\u5df2\u6309\u4e0b!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6309\u94ae\u6309\u4e0b\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void keyUp(Keys keyValue) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).keyUp(this.locator.getSeleniumCurrentLocator(), keyValue.toString());
            } else {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.keyUp(this.element, keyValue).perform();
            }
            message.append("\u6309\u94ae" + keyValue + "\u5df2\u677e\u5f00!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6309\u94ae\u677e\u5f00\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void leftMouseDown() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).mouseDown(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.clickAndHold(this.element).perform();
            }
            message.append("\u9f20\u6807\u5de6\u952e\u5728" + this.wholeComment + "\u5df2\u6309\u4e0b!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u9f20\u6807\u5de6\u952e\u6309\u4e0b\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    public void leftMouseUp() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).mouseUp(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.release(this.element).perform();
            }
            message.append("\u9f20\u6807\u5de6\u952e\u5728" + this.wholeComment + "\u5df2\u677e\u5f00!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u9f20\u6807\u5de6\u952e\u677e\u5f00\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    public void rightMouseDown() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).mouseDownRight(this.locator.getSeleniumCurrentLocator());
            }
            message.append("\u53f3\u952e\u6309\u4e0b\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u53f3\u952e\u6309\u4e0b\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void rightMouseUp() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).mouseUpRight(this.locator.getSeleniumCurrentLocator());
            }
            message.append("\u53f3\u952e\u677e\u5f00\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u53f3\u952e\u677e\u5f00\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void rightMouseClick() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                ((Selenium)currentWindow.getDriver().getEngine()).mouseDownRight(this.locator.getSeleniumCurrentLocator());
                ((Selenium)currentWindow.getDriver().getEngine()).mouseUpRight(this.locator.getSeleniumCurrentLocator());
            } else {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.contextClick(this.element).perform();
            }
            message.append("\u53f3\u952e\u6309\u4e0b\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u53f3\u952e\u6309\u4e0b\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20\uff01");
            this.logger.error(message);
        }
    }

    public void mouseDragAndDrop(Location targetLocation) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (!(currentWindow instanceof SeleniumBrowserWindow) && currentWindow instanceof WebDriverBrowserWindow) {
                Actions action = new Actions((WebDriver)currentWindow.getDriver().getEngine());
                action.dragAndDropBy(this.element, targetLocation.getxLocation(), targetLocation.getyLocation());
            }
            message.append("\u62d6\u62fd\u81f3(" + targetLocation.getxLocation() + "," + targetLocation.getyLocation() + ")\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u62d6\u62fd\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5143\u7d20\uff01");
        }
    }

    public boolean isEditable() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        boolean editable = false;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                editable = ((Selenium)currentWindow.getDriver().getEngine()).isEditable(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                editable = this.element.isEnabled();
            }
            message.append("\u53ef\u7f16\u8f91\u5c5e\u6027\u83b7\u53d6\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u53ef\u7f16\u8f91\u5c5e\u6027\u83b7\u53d6\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
        return editable;
    }

    public boolean isVisable() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        boolean visible = false;
        message.append(String.valueOf(this.wholeComment) + ":");
        if (this.isExist()) {
            if (currentWindow instanceof SeleniumBrowserWindow) {
                visible = ((Selenium)currentWindow.getDriver().getEngine()).isVisible(this.locator.getSeleniumCurrentLocator());
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                visible = this.element.isDisplayed();
            }
            message.append("\u53ef\u89c1\u5c5e\u6027\u83b7\u53d6\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u53ef\u89c1\u5c5e\u6027\u83b7\u53d6\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
        return visible;
    }

    public void assertEqualText(String expected) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            if (expected == null) {
                message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662fnull");
                this.logger.info(message);
            } else {
                message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3anull!");
                this.logger.error(message);
                HolmosWindow.closeAllWindows();
                Assert.fail((String)message.toString());
            }
        } else if (actual.equalsIgnoreCase(expected)) {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662f" + expected);
            this.logger.info(message);
        } else {
            message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3a" + actual + "!");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void assertNotEqualText(String expected) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            if (expected == null) {
                message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662fnull");
                this.logger.error(message);
                HolmosWindow.closeAllWindows();
                Assert.fail((String)message.toString());
            } else {
                message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3anull!");
                this.logger.info(message);
            }
        } else if (actual.equalsIgnoreCase(expected)) {
            message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662f" + expected);
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        } else {
            message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3a" + actual + "!");
            this.logger.info(message);
        }
    }

    public void verifyEqualText(String expected) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            if (expected == null) {
                message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662fnull");
                this.logger.info(message);
            } else {
                message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3anull!");
                this.logger.error(message);
            }
        } else if (actual.equalsIgnoreCase(expected)) {
            message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662f" + actual);
            this.logger.info(message);
        } else {
            message.append("\u6587\u672c\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3a" + actual + "!");
            this.logger.error(message);
        }
    }

    public void verifyNotEqualText(String expected) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            if (expected == null) {
                message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662fnull");
                this.logger.error(message);
            } else {
                message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3anull!");
                this.logger.info(message);
            }
        } else if (actual.equalsIgnoreCase(expected)) {
            message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u548c\u5b9e\u9645\u90fd\u662f" + expected);
            this.logger.error(message);
        } else {
            message.append("\u6587\u672c\u4e0d\u76f8\u540c\u6821\u9a8c\u6210\u529f,\u9884\u671f\u503c\u4e3a" + expected + ",\u5b9e\u9645\u503c\u4e3a" + actual + "!");
            this.logger.info(message);
        }
    }

    public void assertRegMatchText(String regExpected) {
        StringBuilder message = new StringBuilder();
        Pattern pattern = Pattern.compile(regExpected);
        String actual = this.getText();
        Matcher matcher = pattern.matcher(actual);
        message.append(String.valueOf(this.wholeComment) + ":");
        if (matcher.matches()) {
            message.append("\u6b63\u5219\u5339\u914d\u6821\u9a8c\u6210\u529f,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.info(message);
        } else {
            message.append("\u6b63\u5219\u5339\u914d\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void assertNotRegMatchText(String regExpected) {
        StringBuilder message = new StringBuilder();
        Pattern pattern = Pattern.compile(regExpected);
        String actual = this.getText();
        Matcher matcher = pattern.matcher(actual);
        message.append(String.valueOf(this.wholeComment) + ":");
        if (matcher.matches()) {
            message.append("\u6b63\u5219\u4e0d\u5339\u914d\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.info(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        } else {
            message.append("\u6b63\u5219\u4e0d\u5339\u914d\u6821\u9a8c\u6210\u529f,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.error(message);
        }
    }

    public void verifyRegMatchText(String regExpected) {
        StringBuilder message = new StringBuilder();
        Pattern pattern = Pattern.compile(regExpected);
        String actual = this.getText();
        Matcher matcher = pattern.matcher(actual);
        message.append(String.valueOf(this.wholeComment) + ":");
        if (matcher.matches()) {
            message.append("\u6b63\u5219\u5339\u914d\u6821\u9a8c\u6210\u529f,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.info(message);
        } else {
            message.append("\u6b63\u5219\u5339\u914d\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.error(message);
        }
    }

    public void verifyNotRegMatchText(String regExpected) {
        StringBuilder message = new StringBuilder();
        Pattern pattern = Pattern.compile(regExpected);
        String actual = this.getText();
        Matcher matcher = pattern.matcher(actual);
        message.append(String.valueOf(this.wholeComment) + ":");
        if (matcher.matches()) {
            message.append("\u6b63\u5219\u4e0d\u5339\u914d\u6821\u9a8c\u5931\u8d25,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.info(message);
        } else {
            message.append("\u6b63\u5219\u4e0d\u5339\u914d\u6821\u9a8c\u6210\u529f,\u9884\u671f\u7684\u6b63\u5219\u8868\u8fbe\u5f0f\u4e3a:" + regExpected + "|\u5b9e\u9645\u7684\u6587\u672c\u503c\u4e3a:" + actual);
            this.logger.error(message);
        }
    }

    public String getAttribute(String attributeName) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        String attribute = null;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                try {
                    attribute = ((Selenium)currentWindow.getDriver().getEngine()).getAttribute(String.valueOf(this.locator.getSeleniumCurrentLocator()) + "@" + attributeName);
                    message.append("\u5c5e\u6027\u83b7\u53d6\u6210\u529f!");
                    this.logger.info(message);
                }
                catch (Exception e) {
                    message.append("\u5c5e\u6027\u83b7\u53d6\u5931\u8d25\uff0c\u6b64\u5143\u7d20\u6ca1\u6709" + attributeName + "\u5c5e\u6027!");
                    this.logger.error(message);
                }
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                try {
                    attribute = this.element.getAttribute(attributeName);
                    message.append("\u5c5e\u6027\u83b7\u53d6\u6210\u529f!");
                    this.logger.info(message);
                }
                catch (Exception e) {
                    message.append("\u5c5e\u6027\u83b7\u53d6\u5931\u8d25\uff0c\u6b64\u5143\u7d20\u6ca1\u6709" + attributeName + "\u5c5e\u6027!");
                    this.logger.error(message);
                }
            }
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u5c5e\u6027\u83b7\u53d6\u5931\u8d25,\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
        return attribute;
    }

    public void assertInclude(String value) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            message.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u83b7\u53d6\u5143\u7d20\u7684text\u4e3anull!");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        } else if (actual.contains(value)) {
            message.append("\u5305\u542b\u6821\u9a8c\u6210\u529f!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.info(message);
        } else {
            message.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        }
    }

    public void verifyInclude(String value) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            message.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u83b7\u53d6\u5143\u7d20\u7684text\u4e3anull!");
            this.logger.error(message);
        } else if (actual.contains(value)) {
            message.append("\u5305\u542b\u6821\u9a8c\u6210\u529f!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.info(message);
        } else {
            message.append("\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.error(message);
        }
    }

    public void assertNotInclude(String value) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            message.append("\u4e0d\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u83b7\u53d6\u5143\u7d20\u7684text\u4e3anull!");
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        } else if (actual.contains(value)) {
            message.append("\u4e0d\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.error(message);
            HolmosWindow.closeAllWindows();
            Assert.fail((String)message.toString());
        } else {
            message.append("\u4e0d\u5305\u542b\u6821\u9a8c\u6210\u529f!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.info(message);
        }
    }

    public void verifyNotInclude(String value) {
        StringBuilder message = new StringBuilder();
        String actual = this.getText();
        message.append(String.valueOf(this.wholeComment) + ":");
        if (actual == null) {
            message.append("\u4e0d\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u83b7\u53d6\u5143\u7d20\u7684text\u4e3anull!");
            this.logger.error(message);
        } else if (actual.contains(value)) {
            message.append("\u4e0d\u5305\u542b\u6821\u9a8c\u5931\u8d25!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.error(message);
        } else {
            message.append("\u4e0d\u5305\u542b\u6821\u9a8c\u6210\u529f!\u5b9e\u9645\u83b7\u5f97\u7684\u6587\u672c\u4e3a:" + actual + "\u5305\u542b\u5b57\u7b26\u7a9c\u4e3a:" + value);
            this.logger.info(message);
        }
    }

    public void waitForText(String value) {
        StringBuilder message = new StringBuilder();
        int waitCount = 0;
        String actual = null;
        if (this.waitForExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            while (waitCount++ < ConfigConstValue.waitCount) {
                actual = this.getText();
                if (actual == null || !actual.equalsIgnoreCase(value)) continue;
                message.append("\u6587\u672c\u503c:" + value + "\u5df2\u7ecf\u51fa\u73b0!\u7b49\u5f85\u6210\u529f!");
                this.logger.info(message);
                break;
            }
            if (waitCount > ConfigConstValue.waitCount) {
                message.append("\u4e00\u76f4\u7b49\u5230\u6587\u672c" + value + "\u51fa\u73b0\uff0c\u6700\u540e\u4e00\u6b21\u7b49\u5f85\u51fa\u73b0\u7684\u6587\u672c\u662f:" + actual);
                this.logger.error(message);
            }
        }
    }

    public void waitForIncludeText(String value) {
        StringBuilder message = new StringBuilder();
        int waitCount = 0;
        String actual = null;
        if (this.waitForExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            while (waitCount++ < ConfigConstValue.waitCount) {
                actual = this.getText();
                if (actual == null || !actual.contains(value)) continue;
                message.append("\u6587\u672c\u503c:" + value + "\u5df2\u7ecf\u88ab\u5305\u542b!\u7b49\u5f85\u6210\u529f!");
                this.logger.info(message);
                break;
            }
            if (waitCount > ConfigConstValue.waitCount) {
                message.append("\u4e00\u76f4\u7b49\u5230\u6587\u672c" + value + "\u88ab\u5305\u542b\uff0c\u6700\u540e\u4e00\u6b21\u7b49\u5f85\u51fa\u73b0\u7684\u6587\u672c\u662f:" + actual);
                this.logger.error(message);
            }
        }
    }

    public void clickPhone() {
        StringBuilder message = new StringBuilder();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
            if (currentWindow instanceof SeleniumBrowserWindow) {
                message.append("\u60a8\u5f53\u524d\u7528\u7684\u662fselenium\u5f15\u64ce\uff0c\u8fd9\u4e2a\u5f15\u64ce\u4e0d\u652f\u6301");
            } else {
                boolean cfr_ignored_0 = currentWindow instanceof WebDriverBrowserWindow;
            }
        }
    }

    @Override
    public String getLocatorCurrent() {
        return this.locatorCurrent;
    }

    @Override
    public void setLocatorCurrent(String locatorCurrent) {
        this.locatorCurrent = locatorCurrent;
    }

    public String getCSSValue(String cssName) {
        StringBuilder message = new StringBuilder();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
            if (currentWindow instanceof SeleniumBrowserWindow) {
                message.append("\u60a8\u5f53\u524d\u7528\u7684\u662fselenium\u5f15\u64ce\uff0c\u8fd9\u4e2a\u5f15\u64ce\u4e0d\u652f\u6301");
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                return this.element.getCssValue(cssName);
            }
        }
        return null;
    }

    public Dimension getSize() {
        StringBuilder message = new StringBuilder();
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
            if (currentWindow instanceof SeleniumBrowserWindow) {
                message.append("\u60a8\u5f53\u524d\u7528\u7684\u662fselenium\u5f15\u64ce\uff0c\u8fd9\u4e2a\u5f15\u64ce\u4e0d\u652f\u6301");
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                return this.element.getSize();
            }
        }
        return null;
    }

    public Point getLocation() {
        StringBuilder message = new StringBuilder(String.valueOf(this.wholeComment) + ":");
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
            if (currentWindow instanceof SeleniumBrowserWindow) {
                message.append("\u60a8\u5f53\u524d\u7528\u7684\u662fselenium\u5f15\u64ce\uff0c\u8fd9\u4e2a\u5f15\u64ce\u4e0d\u652f\u6301");
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                return this.element.getLocation();
            }
        }
        return null;
    }

    public void highLight() {
        if (this.isExist()) {
            BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
            if (currentWindow instanceof SeleniumBrowserWindow) {
                Selenium selenium = (Selenium)currentWindow.getDriver().getEngine();
                selenium.highlight(this.locatorCurrent);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                HolmosWindow.runJavaScript("arguments[0].style.border = \"5px solid yellow\"", this.element);
            }
        }
    }

    public void submit() {
        StringBuilder message = new StringBuilder(String.valueOf(this.wholeComment) + ":");
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
            if (currentWindow instanceof SeleniumBrowserWindow) {
                Selenium selenium = (Selenium)currentWindow.getDriver().getEngine();
                selenium.submit(this.locatorCurrent);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                this.element.submit();
                this.logger.info("submit\u64cd\u4f5c\u6267\u884c\u6210\u529f");
            }
        }
    }

    public boolean isCreatedByFindElements() {
        return this.isCreatedByFindElements;
    }

    public void setCreatedByFindElements(boolean isCreatedByFindElements) {
        this.isCreatedByFindElements = isCreatedByFindElements;
    }
}

