/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.BrowserWindow;
import com.holmos.webtest.SeleniumBrowserWindow;
import com.holmos.webtest.WebDriverBrowserWindow;
import com.holmos.webtest.element.TextField;
import com.thoughtworks.selenium.Selenium;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class RichTextField
extends TextField {
    public RichTextField(String comment) {
        super(comment);
    }

    public void setBodyText(String value) {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                String js = "selenium.browserbot.getCurrentWindow().document.body.innerHTML='" + value + "';";
                ((Selenium)currentWindow.getDriver().getEngine()).getEval(js);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                String js = "contentWindow.document.body.innerText='" + value + "';";
                WebDriver driver = (WebDriver)currentWindow.getDriver().getEngine();
                ((JavascriptExecutor)driver).executeScript(js, new Object[0]);
            }
            message.append("\u7528body\u6a21\u62df\u7684\u5bcc\u6587\u672c\u8bbe\u7f6e\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u7528body\u6a21\u62df\u7684\u5bcc\u6587\u672c\u8bbe\u7f6e\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }

    public void clearBodyText() {
        StringBuilder message = new StringBuilder();
        BrowserWindow currentWindow = Allocator.getInstance().currentWindow;
        if (this.isExist()) {
            message.append(String.valueOf(this.wholeComment) + ":");
            if (currentWindow instanceof SeleniumBrowserWindow) {
                String js = "selenium.browserbot.getCurrentWindow().document.body.innerHTML='';";
                ((Selenium)currentWindow.getDriver().getEngine()).getEval(js);
            } else if (currentWindow instanceof WebDriverBrowserWindow) {
                String js = "contentWindow.document.body.innerText='';";
                WebDriver driver = (WebDriver)currentWindow.getDriver().getEngine();
                ((JavascriptExecutor)driver).executeScript(js, new Object[0]);
            }
            message.append("\u6e05\u7a7a\u5bcc\u6587\u672c\u6846\u7684\u5185\u5bb9\u6210\u529f!");
            this.logger.info(message);
        } else {
            message.append(String.valueOf(this.wholeComment) + ":");
            message.append("\u6e05\u7a7a\u5bcc\u6587\u672c\u6846\u7684\u5185\u5bb9\u5931\u8d25!\u627e\u4e0d\u5230\u5143\u7d20!");
            this.logger.error(message);
        }
    }
}

