/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element.locator;

import com.holmos.webtest.element.Element;
import com.holmos.webtest.element.locator.Locator;
import com.holmos.webtest.element.locator.LocatorChain;
import java.util.ArrayList;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class AbstractElement {
    public abstract Locator getLocator();

    public abstract String getComment();

    public abstract void setComment(String var1);

    public abstract WebElement getElement();

    public abstract void setElement(WebElement var1);

    public abstract String getLocatorCurrent();

    public abstract void setLocatorCurrent(String var1);

    public abstract boolean isExist();

    public abstract LocatorChain getInfoChain();

    public abstract void setWholeComment(String var1);

    public Element findElement(Locator locator) {
        Element element = new Element("");
        element.setLocator(locator);
        if (this.getInfoChain() != null) {
            element.getInfoChain().addParentNode(this.getInfoChain().getInfoNodes());
        }
        element.getInfoChain().addNode(this);
        return element;
    }

    public ArrayList<Element> findElements(Locator locator) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (this.isExist()) {
            WebElement myself = this.getElement();
            ArrayList<WebElement> webElements = this.getWebElements(myself, locator);
            int index = 0;
            for (WebElement webElement : webElements) {
                Element element = new Element(Integer.toString(index));
                element.setCreatedByFindElements(true);
                element.setElement(webElement);
                elements.add(element);
            }
        }
        return elements;
    }

    private ArrayList<WebElement> getWebElements(WebElement myself, Locator locator) {
        ArrayList webElements = null;
        if (webElements == null && locator.getLocatorById() != null) {
            webElements = (ArrayList)myself.findElements(By.id((String)locator.getLocatorById()));
        }
        if (webElements == null && locator.getLocatorByName() != null) {
            webElements = (ArrayList)myself.findElements(By.name((String)locator.getLocatorByName()));
        }
        if (webElements == null && locator.getLocatorByXpath() != null) {
            webElements = (ArrayList)myself.findElements(By.xpath((String)locator.getLocatorByXpath()));
        }
        if (webElements == null && locator.getLocatorByCSS() != null) {
            webElements = (ArrayList)myself.findElements(By.cssSelector((String)locator.getLocatorById()));
        }
        if (webElements == null && locator.getLocatorByClass() != null) {
            webElements = (ArrayList)myself.findElements(By.className((String)locator.getLocatorByClass()));
        }
        if (webElements == null && locator.getLocatorByTagName() != null) {
            webElements = (ArrayList)myself.findElements(By.tagName((String)locator.getLocatorByTagName()));
        }
        if (webElements == null && locator.getLocatorByTagName() != null) {
            webElements = (ArrayList)myself.findElements(By.linkText((String)locator.getLocatorByTagName()));
        }
        if (webElements == null && locator.getLocatorByPartialLinkText() != null) {
            webElements = (ArrayList)myself.findElements(By.partialLinkText((String)locator.getLocatorByPartialLinkText()));
        }
        return webElements;
    }
}

