/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.element.tool;

import com.holmos.webtest.Allocator;
import com.holmos.webtest.constvalue.ConfigConstValue;
import com.holmos.webtest.constvalue.ConstValue;
import com.holmos.webtest.element.locator.AbstractElement;
import com.holmos.webtest.element.locator.Locator;
import com.holmos.webtest.element.locator.LocatorFinder;
import com.holmos.webtest.element.tool.WebElementExist;
import com.holmos.webtest.struct.Collection;
import com.holmos.webtest.struct.Frame;
import com.holmos.webtest.struct.Page;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverElementExist
extends WebElementExist {
    public WebDriverElementExist(AbstractElement webElement) {
        super(webElement);
    }

    @Override
    public boolean isElementExist(int waitCount) {
        if (this.isElementExistForCheckOnce()) {
            return true;
        }
        this.initComment();
        AbstractElement lastNode = this.infoChain.getInfoNodes().get(this.infoChain.getInfoNodes().size() - 1);
        if (lastNode instanceof Page || lastNode instanceof Frame) {
            return this.findOneLevelElement(waitCount);
        }
        return this.findMuiltiLevelElement(waitCount);
    }

    @Override
    public boolean isElementExistForCheckOnce() {
        AbstractElement lastNode = this.infoChain.getInfoNodes().get(this.infoChain.getInfoNodes().size() - 1);
        if (lastNode instanceof Page || lastNode instanceof Frame) {
            return this.findOneLevelElement(1);
        }
        return this.findMuiltiLevelElement(1);
    }

    private boolean findMuiltiLevelElement(int waitCount) {
        int startLevel = this.infoChain.getInfoNodes().size() - 1;
        while (startLevel > 1) {
            if (this.infoChain.getInfoNodes().get(startLevel) instanceof Frame) {
                ++startLevel;
                break;
            }
            --startLevel;
        }
        WebDriver driverTemp = (WebDriver)Allocator.getInstance().currentWindow.getDriver().getEngine();
        WebElement elementTemp = null;
        elementTemp = this.findElement(new LocatorFinder(driverTemp), this.infoChain.getInfoNodes().get(startLevel));
        if (elementTemp == null) {
            return false;
        }
        int i = startLevel + 1;
        while (i < this.infoChain.getInfoNodes().size()) {
            int j = 0;
            while (j < waitCount) {
                if ((elementTemp = this.findElement(new LocatorFinder(elementTemp), this.infoChain.getInfoNodes().get(startLevel))) != null) break;
                ++j;
            }
            if (elementTemp == null) {
                return false;
            }
            ++i;
        }
        if ((elementTemp = this.findElement(new LocatorFinder(elementTemp), this.element)) != null) {
            this.element.setElement(elementTemp);
            return true;
        }
        return false;
    }

    private boolean findOneLevelElement(int waitCount) {
        LocatorFinder finder = new LocatorFinder(Allocator.getInstance().currentWindow.getDriver().getEngine());
        int i = 0;
        while (i < waitCount) {
            WebElement elementTemp = this.findElement(finder, this.element);
            if (elementTemp != null) {
                this.element.setElement(elementTemp);
                return true;
            }
            ++i;
        }
        return false;
    }

    private WebElement findElement(LocatorFinder finder, AbstractElement webElement) {
        WebElement element = null;
        if (webElement instanceof Collection) {
            int index = ((Collection)webElement).getIndex();
            element = this.findCollection(finder, webElement, index);
        } else {
            element = this.findElementOnly(finder, webElement);
        }
        return element;
    }

    @Override
    public int getListElementSize() {
        if (this.isElementExist(ConfigConstValue.defaultWaitCount)) {
            AbstractElement lastNode = this.infoChain.getInfoNodes().get(this.infoChain.getInfoNodes().size() - 1);
            if (lastNode instanceof Page || lastNode instanceof Frame) {
                return this.getOneLevelListElementSize();
            }
            return this.getMuiltiLevelListElementSize();
        }
        return ConstValue.ERROR;
    }

    @Override
    public int getCollectionSize() {
        return this.getListElementSize();
    }

    private int getMuiltiLevelListElementSize() {
        int startLevel = this.infoChain.getInfoNodes().size() - 1;
        while (startLevel > 1) {
            if (this.infoChain.getInfoNodes().get(startLevel) instanceof Frame) {
                ++startLevel;
                break;
            }
            --startLevel;
        }
        WebDriver driverTemp = (WebDriver)Allocator.getInstance().currentWindow.getDriver().getEngine();
        WebElement elementTemp = null;
        elementTemp = this.findElement(new LocatorFinder(driverTemp), this.infoChain.getInfoNodes().get(startLevel));
        if (elementTemp == null) {
            return -1;
        }
        int i = startLevel + 1;
        while (i < this.infoChain.getInfoNodes().size()) {
            elementTemp = this.findElement(new LocatorFinder(elementTemp), this.infoChain.getInfoNodes().get(startLevel));
            ++i;
        }
        return this.getListElementSize(new LocatorFinder(elementTemp), this.element);
    }

    private int getOneLevelListElementSize() {
        LocatorFinder finder = new LocatorFinder(Allocator.getInstance().currentWindow.getDriver().getEngine());
        return this.getListElementSize(finder, this.element);
    }

    private int getListElementSize(LocatorFinder finder, AbstractElement webElement) {
        Locator locator = webElement.getLocator();
        int size = 0;
        size = this.findListElementSizeById(finder, locator.getLocatorById());
        if (ConstValue.ERROR == size) {
            size = this.findListElementSizeByName(finder, locator.getLocatorByName());
        }
        if (ConstValue.ERROR == size) {
            size = this.findListElementSizeByClass(finder, locator.getLocatorByClass());
        }
        if (ConstValue.ERROR == size) {
            size = this.findListElementSizeByXpath(finder, locator.getLocatorByXpath());
        }
        if (ConstValue.ERROR == size) {
            size = this.findListElementSizeByCss(finder, locator.getLocatorByCSS());
        }
        if (ConstValue.ERROR == size) {
            size = this.findListElementSizeByLinkText(finder, locator.getLocatorByLinkText());
        }
        if (ConstValue.ERROR == size) {
            size = this.findListElementSizeByPartLinkText(finder, locator.getLocatorByPartialLinkText());
        }
        if (ConstValue.ERROR == size) {
            size = this.findListElementSizeByTagName(finder, locator.getLocatorByTagName());
        }
        return size;
    }

    private int findListElementSizeByTagName(LocatorFinder finder, String tagName) {
        if (tagName == null || "".equalsIgnoreCase(tagName)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.tagName((String)tagName)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private int findListElementSizeByPartLinkText(LocatorFinder finder, String partialLinkText) {
        if (partialLinkText == null || "".equalsIgnoreCase(partialLinkText)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.partialLinkText((String)partialLinkText)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private int findListElementSizeByLinkText(LocatorFinder finder, String linkText) {
        if (linkText == null || "".equalsIgnoreCase(linkText)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.linkText((String)linkText)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private int findListElementSizeByCss(LocatorFinder finder, String CSS) {
        if (CSS == null || "".equalsIgnoreCase(CSS)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.cssSelector((String)CSS)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private int findListElementSizeByXpath(LocatorFinder finder, String xpath) {
        if (xpath == null || "".equalsIgnoreCase(xpath)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.xpath((String)xpath)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private int findListElementSizeByClass(LocatorFinder finder, String className) {
        if (className == null || "".equalsIgnoreCase(className)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.className((String)className)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private int findListElementSizeByName(LocatorFinder finder, String name) {
        if (name == null || "".equalsIgnoreCase(name)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.name((String)name)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private int findListElementSizeById(LocatorFinder finder, String id) {
        if (id == null || "".equalsIgnoreCase(id)) {
            return ConstValue.ERROR;
        }
        try {
            return finder.findElements(By.id((String)id)).size();
        }
        catch (Exception e) {
            return ConstValue.ERROR;
        }
    }

    private WebElement findElementOnly(LocatorFinder finder, AbstractElement webElement) {
        Locator locator = webElement.getLocator();
        WebElement element = this.findElementById(finder, locator.getLocatorById());
        if (element == null) {
            element = this.findElementByName(finder, locator.getLocatorByName());
        }
        if (element == null) {
            element = this.findElementByClass(finder, locator.getLocatorByClass());
        }
        if (element == null) {
            element = this.findElementByXpath(finder, locator.getLocatorByXpath());
        }
        if (element == null) {
            element = this.findElementByCss(finder, locator.getLocatorByCSS());
        }
        if (element == null) {
            element = this.findElementByLinkText(finder, locator.getLocatorByLinkText());
        }
        if (element == null) {
            element = this.findElementByPartLinkText(finder, locator.getLocatorByPartialLinkText());
        }
        if (element == null) {
            element = this.findElementByTagName(finder, locator.getLocatorByTagName());
        }
        if (element == null) {
            element = this.findElementByXpath(finder, locator.getXpathFromAttribute());
        }
        return element;
    }

    private WebElement findCollection(LocatorFinder finder, AbstractElement webElement, int index) {
        Locator locator = webElement.getLocator();
        WebElement element = this.findCollectionById(finder, locator.getLocatorById(), index);
        if (element == null) {
            element = this.findCollectionByName(finder, locator.getLocatorByName(), index);
        }
        if (element == null) {
            element = this.findCollectionByClass(finder, locator.getLocatorByClass(), index);
        }
        if (element == null) {
            element = this.findCollectionByXpath(finder, locator.getLocatorByXpath(), index);
        }
        if (element == null) {
            element = this.findCollectionByCss(finder, locator.getLocatorByCSS(), index);
        }
        if (element == null) {
            element = this.findCollectionByLinkText(finder, locator.getLocatorByLinkText(), index);
        }
        if (element == null) {
            element = this.findCollectionByPartLinkText(finder, locator.getLocatorByPartialLinkText(), index);
        }
        if (element == null) {
            element = this.findCollectionByTagName(finder, locator.getLocatorByTagName(), index);
        }
        if (element == null) {
            element = this.findCollectionByXpath(finder, locator.getXpathFromAttribute(), index);
        }
        return element;
    }

    private WebElement findElementByTagName(LocatorFinder finder, String TagName) {
        if (TagName == null || "".equalsIgnoreCase(TagName)) {
            return null;
        }
        try {
            return finder.findElement(By.tagName((String)TagName));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findElementByPartLinkText(LocatorFinder finder, String PartialLinkText) {
        if (PartialLinkText == null || "".equalsIgnoreCase(PartialLinkText)) {
            return null;
        }
        try {
            return finder.findElement(By.partialLinkText((String)PartialLinkText));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findElementByLinkText(LocatorFinder finder, String LinkText) {
        if (LinkText == null || "".equalsIgnoreCase(LinkText)) {
            return null;
        }
        try {
            return finder.findElement(By.linkText((String)LinkText));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findElementByCss(LocatorFinder finder, String CSS) {
        if (CSS == null || "".equalsIgnoreCase(CSS)) {
            return null;
        }
        try {
            return finder.findElement(By.cssSelector((String)CSS));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findElementByXpath(LocatorFinder finder, String Xpath) {
        if (Xpath == null || "".equalsIgnoreCase(Xpath)) {
            return null;
        }
        try {
            return finder.findElement(By.xpath((String)Xpath));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findElementByName(LocatorFinder finder, String Name) {
        if (Name == null || "".equalsIgnoreCase(Name)) {
            return null;
        }
        try {
            return finder.findElement(By.name((String)Name));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findElementById(LocatorFinder finder, String Id) {
        if (Id == null || "".equalsIgnoreCase(Id)) {
            return null;
        }
        try {
            return finder.findElement(By.id((String)Id));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findElementByClass(LocatorFinder finder, String className) {
        if (className == null || "".equalsIgnoreCase(className)) {
            return null;
        }
        try {
            return finder.findElement(By.className((String)className));
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionByTagName(LocatorFinder finder, String TagName, int index) {
        if (TagName == null || "".equalsIgnoreCase(TagName)) {
            return null;
        }
        try {
            return finder.findElements(By.tagName((String)TagName)).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionByPartLinkText(LocatorFinder finder, String PartialLinkText, int index) {
        if (PartialLinkText == null || "".equalsIgnoreCase(PartialLinkText)) {
            return null;
        }
        try {
            return finder.findElements(By.partialLinkText((String)PartialLinkText)).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionByLinkText(LocatorFinder finder, String LinkText, int index) {
        if (LinkText == null || "".equalsIgnoreCase(LinkText)) {
            return null;
        }
        try {
            return finder.findElements(By.linkText((String)LinkText)).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionByCss(LocatorFinder finder, String CSS, int index) {
        if (CSS == null || "".equalsIgnoreCase(CSS)) {
            return null;
        }
        try {
            return finder.findElements(By.cssSelector((String)CSS)).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionByXpath(LocatorFinder finder, String Xpath, int index) {
        if (Xpath == null || "".equalsIgnoreCase(Xpath)) {
            return null;
        }
        try {
            return finder.findElements(By.xpath((String)Xpath)).get(index - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionByName(LocatorFinder finder, String Name, int index) {
        if (Name == null || "".equalsIgnoreCase(Name)) {
            return null;
        }
        try {
            return finder.findElements(By.name((String)Name)).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionById(LocatorFinder finder, String Id, int index) {
        if (Id == null || "".equalsIgnoreCase(Id)) {
            return null;
        }
        try {
            return finder.findElements(By.id((String)Id)).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    private WebElement findCollectionByClass(LocatorFinder finder, String className, int index) {
        if (className == null || "".equalsIgnoreCase(className)) {
            return null;
        }
        try {
            return finder.findElements(By.className((String)className)).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }
}

