/*
 * Decompiled with CFR 0.152.
 */
package com.holmos.webtest.junitextentions.parameters;

import com.holmos.reflect.HolmosReflectCheck;
import com.holmos.reflect.reflectCheck.HolmosRefectionComparatorMode;
import com.holmos.webtest.exceptions.HolmosFailedError;
import com.holmos.webtest.junitextentions.annotations.ValueAssert;
import com.holmos.webtest.junitextentions.annotations.ValueVerify;
import com.holmos.webtest.utils.HolmosTypeCastUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.runners.model.FrameworkMethod;

public class ParameterFrameWorkMethod
extends FrameworkMethod {
    private boolean succeed = false;
    private int index;
    private Object[] parameter;
    private Object[] resultValue;
    private String methodName = null;
    private boolean useParameterAssert = false;

    public ParameterFrameWorkMethod(Method method, Object[] parameter, Object[] resultValue, int index) {
        super(method);
        this.useParameterAssert = method.getAnnotation(ValueAssert.class) != null || method.getAnnotation(ValueVerify.class) != null;
        this.parameter = parameter;
        this.resultValue = resultValue;
        this.index = index;
        this.methodName = method.getName();
    }

    public String toString() {
        if (this.methodName != null) {
            return this.methodName;
        }
        StringBuilder info = new StringBuilder(String.valueOf(this.getName()) + '<');
        if (this.parameter != null) {
            Object[] objectArray = this.parameter;
            int n = this.parameter.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                if (value == null) {
                    info.append("null,");
                }
                if (value instanceof String) {
                    info.append("\"" + value + "\"" + ",");
                } else if (value instanceof StringBuilder) {
                    info.append("\"" + value.toString() + "\"" + ",");
                } else if (value instanceof Number) {
                    info.append(value + ",");
                } else if (value instanceof Character) {
                    info.append("'" + value.toString() + "'" + ",");
                } else if (value instanceof CharSequence) {
                    info.append("\"" + value.toString() + "\"" + ",");
                } else {
                    info.append(value.toString());
                }
                ++n2;
            }
            info = new StringBuilder(info.substring(0, info.length() - 1));
        }
        info.append(">[" + (this.index + 1) + ']');
        return info.toString();
    }

    public Object invokeExplosively(Object target, Object ... parameter) throws Throwable {
        Object result = super.invokeExplosively(target, this.parameter);
        this.succeed = true;
        if (this.useParameterAssert) {
            this.getActualReturnValue(this.getResultValueTypes(result));
            this.assertOrVerify(this.resultValue, result);
        }
        return result;
    }

    private ArrayList<Class<?>> getResultValueTypes(Object result) {
        ArrayList types = new ArrayList();
        if (result == null) {
            return null;
        }
        if (result instanceof List || result instanceof Array || result instanceof Set) {
            for (Object value : (Collection)result) {
                types.add(value.getClass());
            }
        } else {
            throw new HolmosFailedError("holmos\u53c2\u6570\u5316\u6821\u9a8c\u7684\u8fd4\u56de\u503c\u4e0d\u652f\u6301\u9664 List,Array,Set\u4e4b\u5916\u7684\u5176\u4ed6\u7c7b\u578b!\u5982\u6709\u9700\u6c42\uff0c\u8bf7\u8054\u7cfb\u4f5c\u8005!");
        }
        return types;
    }

    private Object[] getActualReturnValue(ArrayList<Class<?>> types) {
        this.resultValue = (Object[])HolmosTypeCastUtils.getParameterEndByBlank(this.resultValue);
        if (types.size() != this.resultValue.length) {
            throw new HolmosFailedError("\u6d4b\u8bd5\u65b9\u6cd5   " + this.methodName + "()  \u4e2d\u7684\u5f85\u6821\u9a8c\u53c2\u6570\u957f\u5ea6\u548c\u53c2\u6570\u6e90\u6587\u4ef6\u4e2d\u7684\u53c2\u6570\u7684\u957f\u5ea6\u4e0d\u4e00\u81f4!");
        }
        Object[] myParameter = new Object[types.size()];
        int i = 0;
        while (i < this.resultValue.length) {
            myParameter[i] = HolmosTypeCastUtils.castObjectAsType(types.get(i), this.resultValue[i]);
            ++i;
        }
        return myParameter;
    }

    private void assertOrVerify(Object expected, Object actual) {
        if (this.getMethod().getReturnType() != Void.TYPE) {
            boolean verify;
            boolean bl = verify = this.getMethod().getAnnotation(ValueAssert.class) == null;
            if (verify) {
                this.verifyCheck(expected, actual);
            } else {
                this.assertCheck(expected, actual);
            }
        }
    }

    private void verifyCheck(Object expected, Object actual) {
        try {
            HolmosReflectCheck.assertEquals((String)(String.valueOf(this.methodName) + "\u6821\u9a8c\u5931\u8d25!"), (Object)expected, (Object)actual, (HolmosRefectionComparatorMode[])new HolmosRefectionComparatorMode[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void assertCheck(Object expected, Object actual) {
        HolmosReflectCheck.assertEquals((String)(String.valueOf(this.methodName) + "\u6821\u9a8c\u5931\u8d25!"), (Object)expected, (Object)actual, (HolmosRefectionComparatorMode[])new HolmosRefectionComparatorMode[0]);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    public void setSucceed(boolean succeed) {
        this.succeed = succeed;
    }
}

